VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "Comdlg32.ocx"
Begin VB.Form frmMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Keithley Model 2520 Demonstration - 2520 Settings"
   ClientHeight    =   7755
   ClientLeft      =   2250
   ClientTop       =   1965
   ClientWidth     =   9465
   FillColor       =   &H00C0C0C0&
   Icon            =   "frmMainv05.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7755
   ScaleWidth      =   9465
   Begin VB.Frame Frame2 
      Height          =   975
      Left            =   2880
      TabIndex        =   56
      Top             =   4440
      Width           =   3135
      Begin VB.Frame Frame1 
         Caption         =   "Output"
         Height          =   735
         Left            =   2160
         TabIndex        =   58
         Top             =   120
         Width           =   735
         Begin VB.Shape shpOutputStatus 
            BackColor       =   &H00C0C0C0&
            FillColor       =   &H00C0C0C0&
            FillStyle       =   0  'Solid
            Height          =   375
            Left            =   195
            Shape           =   3  'Circle
            Top             =   240
            Width           =   375
         End
      End
      Begin VB.CommandButton cmdOutputOnOff 
         BackColor       =   &H00C0C0C0&
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Left            =   360
         Style           =   1  'Graphical
         TabIndex        =   57
         Top             =   240
         Width           =   1455
      End
   End
   Begin VB.Frame fra2510 
      Caption         =   "Module Temp  "
      Height          =   1935
      Left            =   7920
      TabIndex        =   50
      Top             =   840
      Width           =   1455
      Begin VB.ComboBox cboTempOnOff 
         Height          =   315
         ItemData        =   "frmMainv05.frx":030A
         Left            =   360
         List            =   "frmMainv05.frx":0314
         TabIndex        =   54
         Text            =   "OFF"
         Top             =   1440
         Width           =   735
      End
      Begin VB.ComboBox cboSetpoint 
         Height          =   315
         Left            =   360
         TabIndex        =   51
         Text            =   "Combo1"
         Top             =   480
         Width           =   735
      End
      Begin VB.Label Label1 
         Caption         =   "2510 Temp Control"
         Height          =   375
         Left            =   240
         TabIndex        =   55
         Top             =   960
         Width           =   975
      End
      Begin VB.Label lblC 
         Caption         =   "C"
         Height          =   255
         Left            =   1200
         TabIndex        =   53
         Top             =   480
         Width           =   135
      End
      Begin VB.Label lblSetpoint 
         Caption         =   "2510 Setpoint"
         Height          =   255
         Left            =   240
         TabIndex        =   52
         Top             =   240
         Width           =   1095
      End
   End
   Begin VB.Frame fraMeasure 
      Caption         =   "2520 Measure Parameters"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2055
      Left            =   120
      TabIndex        =   32
      Top             =   5520
      Width           =   9135
      Begin VB.Frame fraDUT 
         Caption         =   "DUT type"
         Height          =   1575
         Left            =   120
         TabIndex        =   45
         Top             =   360
         Width           =   1695
         Begin VB.OptionButton optDUTtype 
            Caption         =   "500 mA Resistor"
            Height          =   255
            Index           =   0
            Left            =   120
            TabIndex        =   48
            Top             =   360
            Width           =   1455
         End
         Begin VB.OptionButton optDUTtype 
            Caption         =   "5A Resistor"
            Height          =   255
            Index           =   1
            Left            =   120
            TabIndex        =   47
            Top             =   720
            Width           =   1455
         End
         Begin VB.OptionButton optDUTtype 
            Caption         =   "Expert Mode"
            Height          =   255
            Index           =   2
            Left            =   120
            TabIndex        =   46
            Top             =   1080
            Width           =   1455
         End
      End
      Begin VB.Frame fraKinkTest 
         Caption         =   "Kink Test"
         Height          =   1095
         Left            =   7800
         TabIndex        =   42
         Top             =   360
         Width           =   1215
         Begin VB.OptionButton optKinkTest 
            Caption         =   "Det 1"
            Height          =   255
            Index           =   0
            Left            =   240
            TabIndex        =   44
            Top             =   360
            Value           =   -1  'True
            Width           =   735
         End
         Begin VB.OptionButton optKinkTest 
            Caption         =   "Det 2"
            Height          =   255
            Index           =   1
            Left            =   240
            TabIndex        =   43
            Top             =   720
            Width           =   735
         End
      End
      Begin VB.CheckBox chkSaveData 
         Caption         =   "Save Data ?"
         Height          =   375
         Left            =   7800
         TabIndex        =   41
         Top             =   1560
         Width           =   1215
      End
      Begin VB.Frame fraMeasureRange 
         Caption         =   "Pulse and Detector Measure Range"
         Height          =   1575
         Left            =   1920
         TabIndex        =   33
         Top             =   360
         Width           =   5775
         Begin VB.Frame fraDet2 
            Caption         =   "Detector 2"
            Height          =   1095
            Left            =   3720
            TabIndex        =   38
            Top             =   320
            Width           =   1935
            Begin VB.OptionButton optDet2Polarity 
               Caption         =   "Pos"
               Height          =   255
               Index           =   1
               Left            =   1200
               TabIndex        =   65
               Top             =   480
               Width           =   615
            End
            Begin VB.OptionButton optDet2Polarity 
               Caption         =   "Neg"
               Height          =   255
               Index           =   0
               Left            =   1200
               TabIndex        =   64
               Top             =   720
               Width           =   615
            End
            Begin VB.ComboBox cboDet2CurrRng 
               Height          =   315
               ItemData        =   "frmMainv05.frx":0321
               Left            =   240
               List            =   "frmMainv05.frx":0331
               Style           =   2  'Dropdown List
               TabIndex        =   39
               Top             =   520
               Width           =   855
            End
            Begin VB.Label lblPolarity 
               Caption         =   "Polarity"
               Height          =   255
               Index           =   1
               Left            =   1200
               TabIndex        =   66
               Top             =   240
               Width           =   615
            End
            Begin VB.Label lblDet2CurrRng 
               Caption         =   "Range (A)"
               Height          =   255
               Left            =   240
               TabIndex        =   40
               Top             =   240
               Width           =   735
            End
         End
         Begin VB.Frame fraDet1 
            Caption         =   "Detector 1"
            Height          =   1095
            Left            =   1680
            TabIndex        =   35
            Top             =   320
            Width           =   1935
            Begin VB.OptionButton optDet1Polarity 
               Caption         =   "Neg"
               Height          =   255
               Index           =   0
               Left            =   1200
               TabIndex        =   63
               Top             =   720
               Width           =   615
            End
            Begin VB.OptionButton optDet1Polarity 
               Caption         =   "Pos"
               Height          =   255
               Index           =   1
               Left            =   1200
               TabIndex        =   62
               Top             =   480
               Width           =   615
            End
            Begin VB.ComboBox cboDet1CurrRng 
               Height          =   315
               ItemData        =   "frmMainv05.frx":0351
               Left            =   240
               List            =   "frmMainv05.frx":0361
               Style           =   2  'Dropdown List
               TabIndex        =   36
               Top             =   520
               Width           =   855
            End
            Begin VB.Label lblPolarity 
               Caption         =   "Polarity"
               Height          =   255
               Index           =   0
               Left            =   1200
               TabIndex        =   61
               Top             =   240
               Width           =   615
            End
            Begin VB.Label lblDet1CurrRng 
               Caption         =   "Range (A)"
               Height          =   255
               Left            =   240
               TabIndex        =   37
               Top             =   240
               Width           =   735
            End
         End
         Begin VB.Frame fraVmeas 
            Caption         =   "Pulse V Measure"
            Height          =   1095
            Left            =   120
            TabIndex        =   34
            Top             =   320
            Width           =   1455
            Begin VB.ComboBox cboVmeas 
               Height          =   315
               Left            =   240
               Style           =   2  'Dropdown List
               TabIndex        =   59
               Top             =   480
               Width           =   615
            End
            Begin VB.Label lblV 
               Caption         =   "Range (V)"
               Height          =   255
               Left            =   240
               TabIndex        =   60
               Top             =   240
               Width           =   735
            End
         End
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   480
      Top             =   0
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Frame fraSource 
      Caption         =   "2520 Source Parameters"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3495
      Left            =   120
      TabIndex        =   0
      Top             =   840
      Width           =   7695
      Begin VB.Frame fraDetBias 
         Caption         =   "Detector Bias"
         Height          =   1335
         Left            =   5640
         TabIndex        =   27
         Top             =   240
         Width           =   1800
         Begin VB.TextBox txtDet2Bias 
            Alignment       =   1  'Right Justify
            Height          =   285
            Left            =   960
            TabIndex        =   30
            Text            =   "0"
            Top             =   720
            Width           =   495
         End
         Begin VB.TextBox txtDet1Bias 
            Alignment       =   1  'Right Justify
            BeginProperty DataFormat 
               Type            =   0
               Format          =   "0"
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
            Height          =   285
            Left            =   240
            TabIndex        =   28
            Text            =   "0"
            Top             =   720
            Width           =   495
         End
         Begin VB.Label lblDet2Bias 
            Caption         =   "Det 2 (V)"
            Height          =   255
            Left            =   960
            TabIndex        =   31
            Top             =   480
            Width           =   735
         End
         Begin VB.Label lblDet1Bias 
            Caption         =   "Det 1 (V)"
            Height          =   255
            Left            =   120
            TabIndex        =   29
            Top             =   480
            Width           =   735
         End
      End
      Begin VB.Frame fraSweepParam 
         Caption         =   "Current Source Parameters"
         Height          =   1695
         Left            =   240
         TabIndex        =   13
         Top             =   1680
         Width           =   7215
         Begin VB.CheckBox chkSinglePulse 
            Caption         =   "Single Pulse && Graph Pulse Trace"
            Enabled         =   0   'False
            Height          =   255
            Left            =   3600
            TabIndex        =   49
            Top             =   1200
            Width           =   2775
         End
         Begin VB.ComboBox cboStopCurrent 
            Height          =   315
            ItemData        =   "frmMainv05.frx":0381
            Left            =   3240
            List            =   "frmMainv05.frx":0383
            TabIndex        =   20
            Top             =   480
            Width           =   1200
         End
         Begin VB.ComboBox cboStepCurrent 
            Height          =   315
            ItemData        =   "frmMainv05.frx":0385
            Left            =   4560
            List            =   "frmMainv05.frx":0395
            TabIndex        =   19
            Text            =   "0.010"
            Top             =   480
            Width           =   1440
         End
         Begin VB.ComboBox cboStartCurrent 
            Height          =   315
            ItemData        =   "frmMainv05.frx":03B5
            Left            =   1920
            List            =   "frmMainv05.frx":03C5
            TabIndex        =   18
            Top             =   480
            Width           =   1200
         End
         Begin VB.TextBox txtDCcurrent 
            Enabled         =   0   'False
            Height          =   285
            Left            =   1920
            TabIndex        =   17
            Top             =   1200
            Width           =   615
         End
         Begin VB.OptionButton optOutputMode 
            Caption         =   "Fixed"
            Height          =   255
            Index           =   1
            Left            =   960
            TabIndex        =   16
            Top             =   1200
            Width           =   855
         End
         Begin VB.OptionButton optOutputMode 
            Caption         =   "Sweep"
            Height          =   255
            Index           =   0
            Left            =   960
            TabIndex        =   15
            Top             =   480
            Width           =   975
         End
         Begin VB.TextBox txtSteps 
            Appearance      =   0  'Flat
            BackColor       =   &H00C0C0C0&
            BorderStyle     =   0  'None
            Height          =   315
            Left            =   6120
            Locked          =   -1  'True
            TabIndex        =   14
            Top             =   480
            Width           =   615
         End
         Begin VB.Image imgPulse 
            Appearance      =   0  'Flat
            Height          =   375
            Index           =   2
            Left            =   3120
            Picture         =   "frmMainv05.frx":03E5
            Top             =   1080
            Width           =   375
         End
         Begin VB.Image imgDCFixed 
            Appearance      =   0  'Flat
            Height          =   450
            Left            =   240
            Picture         =   "frmMainv05.frx":0B93
            Top             =   1005
            Width           =   600
         End
         Begin VB.Image imgPulseFixed 
            Appearance      =   0  'Flat
            Height          =   450
            Left            =   240
            Picture         =   "frmMainv05.frx":19E5
            Top             =   1005
            Width           =   600
         End
         Begin VB.Image imgPulseSweep 
            Appearance      =   0  'Flat
            Height          =   450
            Left            =   240
            Picture         =   "frmMainv05.frx":2837
            Top             =   285
            Width           =   600
         End
         Begin VB.Label lblStart 
            Caption         =   "Start Current (A)"
            Height          =   255
            Left            =   1920
            TabIndex        =   26
            Top             =   240
            Width           =   1215
         End
         Begin VB.Label lblStop 
            Caption         =   "Stop Current (A)"
            Height          =   255
            Left            =   3240
            TabIndex        =   25
            Top             =   240
            Width           =   1215
         End
         Begin VB.Label lblStep 
            Caption         =   "Step Current (A)"
            Height          =   255
            Left            =   4680
            TabIndex        =   24
            Top             =   240
            Width           =   1335
         End
         Begin VB.Label lblDCcurrent 
            Caption         =   "A"
            Height          =   255
            Left            =   2595
            TabIndex        =   23
            Top             =   1215
            Width           =   135
         End
         Begin VB.Label lblFixed 
            Caption         =   "Fixed Current"
            Height          =   255
            Left            =   1920
            TabIndex        =   22
            Top             =   960
            Width           =   1215
         End
         Begin VB.Image imgDCsweep 
            Appearance      =   0  'Flat
            Height          =   450
            Left            =   240
            Picture         =   "frmMainv05.frx":3689
            Top             =   285
            Width           =   600
         End
         Begin VB.Label lblSteps 
            Caption         =   "Steps"
            Height          =   255
            Left            =   6120
            TabIndex        =   21
            Top             =   240
            Width           =   495
         End
      End
      Begin VB.Frame fraOutputShape 
         Caption         =   "Current Source Shape"
         Height          =   1335
         Left            =   240
         TabIndex        =   1
         Top             =   240
         Width           =   5295
         Begin VB.OptionButton optShape 
            Caption         =   "Pulse"
            Height          =   375
            Index           =   0
            Left            =   960
            MaskColor       =   &H00FFFFFF&
            Picture         =   "frmMainv05.frx":44DB
            TabIndex        =   6
            Top             =   360
            UseMaskColor    =   -1  'True
            Width           =   735
         End
         Begin VB.OptionButton optShape 
            Caption         =   "DC"
            Height          =   255
            Index           =   1
            Left            =   960
            TabIndex        =   5
            Top             =   960
            Width           =   735
         End
         Begin VB.ComboBox cboPulseWidth 
            Height          =   315
            ItemData        =   "frmMainv05.frx":4589
            Left            =   1800
            List            =   "frmMainv05.frx":458B
            TabIndex        =   4
            Top             =   480
            Width           =   975
         End
         Begin VB.ComboBox cboPulseDelay 
            Height          =   315
            ItemData        =   "frmMainv05.frx":458D
            Left            =   3120
            List            =   "frmMainv05.frx":458F
            TabIndex        =   3
            Top             =   480
            Width           =   855
         End
         Begin VB.TextBox txtDuty 
            Alignment       =   1  'Right Justify
            Appearance      =   0  'Flat
            BackColor       =   &H8000000B&
            BorderStyle     =   0  'None
            BeginProperty DataFormat 
               Type            =   0
               Format          =   "0.0%"
               HaveTrueFalseNull=   0
               FirstDayOfWeek  =   0
               FirstWeekOfYear =   0
               LCID            =   1033
               SubFormatType   =   0
            EndProperty
            Height          =   285
            Left            =   4440
            Locked          =   -1  'True
            TabIndex        =   2
            TabStop         =   0   'False
            Top             =   480
            Width           =   495
         End
         Begin VB.Image Image1 
            Appearance      =   0  'Flat
            Height          =   375
            Left            =   360
            Picture         =   "frmMainv05.frx":4591
            Top             =   840
            Width           =   375
         End
         Begin VB.Label lblPulseWidth 
            Caption         =   "Pulse Width"
            Height          =   255
            Left            =   1800
            TabIndex        =   12
            Top             =   240
            Width           =   975
         End
         Begin VB.Label lblPulseDelay 
            Caption         =   "Pulse Off Time"
            Height          =   255
            Left            =   3120
            TabIndex        =   11
            Top             =   240
            Width           =   1095
         End
         Begin VB.Label lblmS 
            Caption         =   "uS"
            Height          =   255
            Index           =   0
            Left            =   2805
            TabIndex        =   10
            Top             =   510
            Width           =   255
         End
         Begin VB.Label lblmS 
            Caption         =   "uS"
            Height          =   255
            Index           =   1
            Left            =   4005
            TabIndex        =   9
            Top             =   510
            Width           =   255
         End
         Begin VB.Label lblDuty 
            Caption         =   "Duty Cycle"
            Height          =   255
            Left            =   4320
            TabIndex        =   8
            Top             =   240
            Width           =   855
         End
         Begin VB.Label lblPercent 
            Caption         =   "%"
            Height          =   255
            Left            =   5040
            TabIndex        =   7
            Top             =   480
            Width           =   135
         End
         Begin VB.Image imgPulse 
            Appearance      =   0  'Flat
            Height          =   375
            Index           =   0
            Left            =   360
            Picture         =   "frmMainv05.frx":4D3F
            Top             =   360
            Width           =   375
         End
      End
   End
   Begin VB.Image Image3 
      Appearance      =   0  'Flat
      Height          =   585
      Left            =   6600
      Picture         =   "frmMainv05.frx":54ED
      Stretch         =   -1  'True
      Top             =   15
      Width           =   2700
   End
   Begin VB.Label lblMeasureWarn 
      Caption         =   "Label2"
      Height          =   855
      Left            =   360
      TabIndex        =   67
      Top             =   4560
      Width           =   2175
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuQuit 
         Caption         =   "&Quit"
      End
   End
   Begin VB.Menu mnuSettings 
      Caption         =   "&Settings"
      Begin VB.Menu mnuGPIBSettings 
         Caption         =   "&GPIB Settings"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "&About"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*******************************************************************
'***                                                             ***
'***             2520 Pulse LIV Sweep Test Demo                  ***
'***                                                             ***
'*******************************************************************
'
'This demo is intended to exercise the Keithley Model 2520
'to perform a pulsed or Fixed (DC) L-I-V sweep test on a demo DUT (device under test).
'This code was created for two different resistor-based DUTs.
'500 mA DUT has about 16.67 ohm across Current output and 1 kohm resistors
'for the detector channels.  Det 1 has a 1 kohm from the HI side and
'Det 2 has a 1 kohm attached to the LO side of the 16.67 ohm resistor.
'5 A DUT has about 1.6 ohm across Current output and 1 kohm resistors
'for the detector channels.  The main DUT resistance is chosen to keep the
'max current x resistance < 10 V (max V for 2520).  Det 1 has a 1 kohm from
'the HI side and Det 2 has a 1 kohm attached to the LO side of the 16.67 ohm
'resistor.  Resistors were chosen to showcase the inherent performance of
'the 2520.  Other DUTs, such as a IR LED or laser diode, are possible.
'Use the Expert Mode to drive these DUT types.
'
'                   Resistor DUT Schematic
'
'                                     1 kOhm
' Current HI -------------------+----/\/\/\/\-----Det 2
'                               |-------------------Scope (coax outer)
'Volt sense HI------------------|
'                               /
'                               \   1.6 Ohm (for 5A Resistor DUT)
'                               /    or
'                               \   16 Ohm (for 500 mA DUT)
'                               |
'Volt sense LO------------------|             50 ohm
'                               |------------/\/\/\----Scope (coax center)
' Current LO--------------------+----/\/\/\/\-----Det 1
'                                    1 kOhm
'
'The above DUT is used in "differential mode", where "the Detector" signal = Det 1 current - Det 2 current.
'This subtraction is done to remove any ground transients (2520 pulse crkt not designed to
'to supply current to detector channels), resulting in a single detector channel.
'Note that this difference may also be implemented using the SCPI CALC4 command, but this
'version just uses the VB code to implement the subtraction
'
'Note that this demo software will also drive a laser diode module and read
'back the two photodiode (detector) channels - use the IR LED mode.
'This demo was designed to work over GPIB (KPCI-488 (aka CEC), Nat'l Instruments)
'and the RS-232 port.  Because of inherent limit of the RS-232 bus/standard,
'data transfer over RS-232 are many times slower than GPIB.
'Modifications to this program may be required to test/attain the
'required kink detection sensitivity.
'
'This is the SCPI version of the 2520 VB Demo, there is also a version
'that uses VISA drivers written by Keithley.
'
'Note that very little error checking and no error handling is used
'in this program.
'In a production environment, error checking and
'handling would be a must.  In the 500 mA and 5A (resistor) DUT modes, this
'program does check for max current, duty cycle and minimum sweep step sizes
'
'=======================================================================
'Microsoft Visual Basic Requirements
'
'This program was written in VB 6.0 Professional Edition
'Certain features, such as _Validate have been utilized, which were not
'available in VB <6.0. (See Sub ValidateAll for remedies to _Validate)
'Professional Edition includes MSChart, not available in the Learning Edition of VB
'
'=======================================================================
'DRIVER & FILE REQUIREMENTS
'
'Project Files:
'2520DemoSCPI-vXX.vbp
'frmAbout.frm
'frmMainb.frm
'frmGPIBSettings.frm
'frmPulseChart.frm
'frmSweepChart.frm
'
'Modules
'Declarations (Filename: Declarations.bas)
'mod_CEC (ieeevb.bas)                       'CEC driver. Note this file has been modified to include a wrapper for CEC and & NI card communication
'mod_GPIBwrapper (mod_GPIBwrapper.bas)      'GPIB "wrapper", used to route SCPI commands based on user-determined GPIB card type
'mod_SettingsFile (mod_SettingsFile.bas)    'Procedure for saving settings to file (strSetFile)
'NIGLOBAL (niglobal.bas)                    'NI GPIB driver
'VBIB32 (vbib-32.bas)                       'NI GPIB driver
'
'References                                     File Location (not a required locn, just actual file locn)
'Visual Basic for Applications                  (C:\WINNT\System32\Msvbvm60.dll)
'Visual Basic runtime objects and procedures    (C:\WINNT\System32\Msvbvm60.dll/3)
'Visual Basic Objects and Procedures            (C:\Program Files\Microsoft Visual Studio\VB98\VB6.OLB)
'Microsoft Data Formatting Object Library       (C:\WINNT\System32\MSSTDFMT.DLL)
'Microsoft Excel 9.0 Object Library             (C:\Program Files\Microsoft Office\Office\EXCEL9.OLB)
'
'--------------------------------------------------------------------
'NO WARRANTY
'
'THERE IS NO WARRANTY FOR THE PROGRAM. THE PROGRAM "AS IS" WITHOUT
'WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
'NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
'FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE
'QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE
'PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
'SERVICING, REPAIR OR CORRECTION.
'---------------------------------------------------------------------


Public PulseWidth As Double                 'Width of current pulse, in seconds
Public PulseDelay As Double                 'Delay (pulse OFF time) between pulses, in seconds
Public SweepStart As Single                 'Start current value for sweep, in Amps
Public SweepStartMax As Single              'Maximum current for sweep start (set to just less than SweepStopMax), in A
Public SweepStop As Single                  'Final current value for sweep, in A
Public SweepStopMax As Single               'Maximum final current for sweep, based on DUT type/current source range, in A
Public SweepStep As Single                  'Sweep current step size, in A
Public SweepStepMin As Single               'Minimum sweep step size, based on DUT type/current source range, in A
Public FixedCurrent As Single               'Value for current fixed (DC) source, in A
Public FixedCurrentMax As Single            'Max value for either DC fixed or Pulse Fixed Current, depending on user chosen mode
Public Det1Bias As Single                   'Detector channel 1 voltage bias
Public Det2Bias As Single                   'Detector channel 2 voltage bias
Public Det1Polarity As Integer              'Detector channel 1 current measure polarity
Public Det2Polarity As Integer              'Detector channel 2 current measure polarity
Public PulseTrans As Integer                'Current Pulse transition (0=Fast, 1=slow), initial demo code does fast ONLY
Public bln2520Output As Boolean             'boolean variable for state of 2520 Output
Public CurrentMax As Single                 'Max current for chosen DUT/range
Public Setpoint As Single                   'Temperature Setpoint for 2510 TEC control
Public CurrentRange As Integer              'Current Source Range, 0=500 mA, 1=5A
'Public OutputShape As ViInt32               'Current Output Shape, 1=Pulse, 2=DC
Public OutputShape As Integer               'Current Output Shape, 1=Pulse, 2=DC
Public StartTime As Single                  'Start time of the sweep (roughly)
'Public dblMean As Double                    'Mean value for dL2/dI2 (second derivative)
Public PulsePoints As Integer               'Number of points in the Pulse (Trace) Buffer
Public Quit As Boolean                      'Quit program? variable

Const VBiasMax = 20                         'Maximum 2520 detector channel bias is 20 V
Const VBiasMin = -20                        'Minimum 2520 detector channel bias is -20 V
Const PulseWidthMin = 0.5                   'Min Pulse Width (On time) is 500 nsec, using usec as display range
Const PulseWidthMax = 5000                  'Max Pulse Width (On time) is 5 ms, using usec as display range
Const PulseDelayMin = 20                    'Min Delay Pulse (off time) is 20 us, using us as default display range
Const PulseDelayMax = 500000                'Max Delay Pulse (off time) is 500 ms, using us as default display range
Const SweepStartMin As Double = 0           'Minimum Sweep start current is 1 mA
Const DCCurrentMax = 1                      'Maximum fixed (DC) current for the 2520 is 1A

Private Sub cboPulseWidth_Validate(Cancel As Boolean)
'Ensure that Pulse Width is within acceptable limits
'And calculate Duty Cycle
'Note that _Validate was first available in VB 6, see Sub ValidateAll for more

Call ValidateAll

End Sub

Private Sub cboPulseDelay_Validate(Cancel As Boolean)
'Ensure that Pulse Delay (i.e., Pulse off time )is within
'acceptable limits and calculate Duty Cycle

Call ValidateAll

End Sub

Private Sub cboSetpoint_Validate(Cancel As Boolean)
'Check specified temperature setpoint for TEC

Call ValidateAll

End Sub

Private Sub cboStartCurrent_Validate(Cancel As Boolean)
'Check and coerce the Sweep Start current

Call ValidateAll

End Sub

Private Sub cboStepCurrent_Validate(Cancel As Boolean)
'Check and coerce the Sweep step current value

Call ValidateAll

End Sub

Private Sub cboStopCurrent_Validate(Cancel As Boolean)
'Check and coerce the Sweep Stop current

Call ValidateAll

End Sub

Private Sub cboTempOnOff_Click()
'This basic routine initializes, configures and turns on or off 2510 temp control
'Note the 2510 controls are only visible/available in the expert mode
'and are intended for pulse testing TEC-equipped laser diode modules/packages

'Dim strData As String

If cboTempOnOff.Text = "ON" Then                'Initialize and turn temp control ON

    'Initialise 2510, using VISA dll driver, and get session handle for 2510
'    nErr = Ke2510_init("GPIB0::" & intKI2510 & "::INSTR", VI_ON, handle2510)   'GPIB: Reset 2510 and get handle
'        If nErr <> 0 Then
'            DisplayError handle2510, nErr
'        End If

    'Set protection limits (for basic demo TEC)
'    nErr = Ke2510_SetCurrentProtection(handle2510, 2.2)        'Set current prot limit=2.2A
'        If nErr <> 0 Then                                       'If error from instrument, display in msgbox
'            DisplayError handle2510, nErr
'        End If
'    nErr = Ke2510_ConfigureVoltageSourceMode(handle2510, 1.2, 1, 1, 1, 7.2)   'Set volt prot limit=7.2V
'        If nErr <> 0 Then                                       'If error from instrument, display in msgbox
'            DisplayError handle2510, nErr
'        End If

    'Configure temperature PID and setpoint
'    nErr = Ke2510_ConfigureTemperatureSourceMode(handle2510, CDbl(cboSetpoint.Text), 101.3, 0.92, _
'           28.1, 1, 15, 55)                                         'Set setpoint(cboSetPoint), P, I, D, templimit enabled, lowtemp limit, hightemp limit
'        If nErr <> 0 Then
'            DisplayError handle2510, nErr
'        End If

    'Enable output (turn on temp control)
'    nErr = Ke2510_EnableSourceOutput(handle2510, VI_ON)
'        If nErr <> 0 Then
'            DisplayError handle2510, nErr
'        End If

'    ErrorStatus = SendKI(intKi2510, "*rst")
'    If ErrorStatus Then
'        MsgBox ErrorStatus
'    End If
'    If SendKI(intKI2510, "*rst") Then Exit Sub
    If SendKI(intKI2510, ":sens:curr:prot:lev 1.0") Then Exit Sub       'Set max current to 1A
'    If SendKI(intKI2510, ":sens:temp:tran ther") Then Exit Sub         'Choose temp transducer=thermistor
'    If SendKI(intKI2510, ":sens:temp:curr:auto on") Then Exit Sub      'Choose auto-range current for thermistor
'    If SendKI(intKI2510, ":sens:temp:ther:range 1e4") Then Exit Sub    'Choose 10K thermistor
    If SendKI(intKI2510, ":sour:temp:spo " & cboSetpoint.Text) Then Exit Sub    'Grab temp setpoint from control
    If SendKI(intKI2510, ":outp on") Then Exit Sub                      'Turn on temp control

Else        'cboTempOnOff = OFF, turn 2510 output off
   
'    Call send(intKi2510, "*rst", intStatus)
    Call SendKI(intKI2510, ":outp off")                                 'Turn off Temp Control
   
'    nErr = Ke2510_EnableSourceOutput(handle2510, VI_OFF)    'Turn 2510 output off
'        If nErr <> 0 Then
'            DisplayError handle2510, nErr
'        End If
    
'    nErr = Ke2510_close(handle2510)                     'Close session to instrument
'        If nErr <> 0 Then
'            DisplayError handle2510, nErr
'        End If

End If

End Sub

Private Sub cboVmeas_Validate(Cancel As Boolean)
'Check setting, if current is too high (>2.5A on 5A DUT or >250 mA on 500 mA DUT)
'Then set to 10V, no checking done for Expert Mode

Call ValidateAll

End Sub


Private Sub chkSinglePulse_Click()
'Mode chosen:  do a single pulse and retrieve/graph the Vmeasure Pulse (GPIB cmd:trace:data?)
'This routine just sets the proper controls labels and sets visible/invisible

If chkSinglePulse.value Then                    'Single Pulse mode chosen
    cmdOutputOnOff.Caption = "Single Pulse"     'Label Output button for Single Pulse operation
    cmdOutputOnOff.ToolTipText = "Press to trigger single pulse and retrieve pulse trace"
    lblMeasureWarn.Visible = False              'Hide Measure warning text

Else                'Unchecked - not in Single Pulse mode
    lblMeasureWarn.Visible = True               'Display Measure warning
    cmdOutputOnOff.Caption = "Output ON"     'Label Output button for Single Pulse operation
End If

End Sub

Private Sub cmdOutputOnOff_Click()
'This procedure turns the 2520 output ON, either for Fixed (DC) or Sweep mode
'Note that if 2520 output is already ON, then a change in the mode to Sweep will turn

Call ValidateAll                        'Make sure all values are OK, *_Validate may not have operated on last changed control

Call CheckInterlock

Select Case True

    Case optOutputMode(0).value                 'Sweep (DC or Pulse) Mode

        ConfigSweep2520
        Call DoSweep
        blnTimeUpdate = True                    'Set flag to permit updating of elapsed time for sweep
        frmSweepChart.ChartData                 'Display data on frmSweepChart
        If chkSaveData Then                     'If save data is checked, then run save data routine
            Call Save_Click
        End If
    
    Case optOutputMode(1).value                 'Fixed (DC or Pulse) Mode
'       NOTE:  This demo program does not collect data in the Fixed DC or Fixed Pulse mode (except for single pulse)
        
        If (chkSinglePulse.value = False) Then          'Not in Single Pulse mode?
            
            If bln2520Output Then               'Is 2520 Output already ON?
                Call OutputOff                  'Turn 2520 Output OFF
                cmdOutputOnOff.Caption = "Output On"        'Label button for Fixed (DC) operation
                shpOutputStatus.FillColor = &HC0C0C0        'Change Output ON/Off indicator back to grey
                DoEvents                                    'Redraws form, required for output indicator color change
            
            Else                                'Fixed mode, but 2520 output is OFF
            ConfigFixed2520                     'Configure 2520 for fixed DC or fixed pulse
            If SendKI(intKI2520, ":outp on") Then Exit Sub    'Turn 2520 Output ON
            If SendKI(intKI2520, ":init") Then Exit Sub             'Initiate Trigger, req'd for infinite pulse mode

'            nErr = Ke2520_EnableSourceOutput(handle2520, VI_TRUE)       'Turn 2520 Output ON
'                If nErr <> 0 Then                           'If GPIB/2520 error, display it
'                DisplayError handle2520, nErr
'                End If
'            nErr = Ke2520_Initiate(handle2520)              'Initiate Trigger, req'd for infinite pulse mode
'                If nErr <> 0 Then
'                DisplayError handle2520, nErr
'                End If
            
            bln2520Output = True                            'Set 2520 output status variable
            cmdOutputOnOff.Caption = "Output Off"           'Label button for Fixed (DC) operation
            cmdOutputOnOff.ToolTipText = "Click to turn 2520 Output OFF"
            shpOutputStatus.FillColor = &HFF0000            'make Output indicator Blue &H3366FF
            DoEvents                                        'Redraws form, required for output indicator color change
            End If
        
        Else                                'Single Pulse Mode
            ConfigPulse2520                                 'Configure 2520 for single fixed pulse
            ChartPulse                                      'Graph the pulse data
        End If

End Select

If bln2520Output Then                       'If output is on (ie, using Fixed mode) then disable DUT choice box
    fraDUT.Enabled = False
    Else
    fraDUT.Enabled = True
End If

End Sub

Private Sub Form_Initialize()
'Initialize all combo boxes, tooltiptexts and variables

'Hide detector channel Kink Test frame, because choice of channel
'for kink test not yet implemented in code
fraKinkTest.Visible = False

'Populate Sweep Current combo boxes with values common to all 3 DUTs (or, default values)
'See SetRange(0) for population of cboStartCurrent and cboStopCurrent
'Populate Detector Channel text and combo boxes (Voltage Bias, Detector channel current measure)
    'Detector 1
    cboDet1CurrRng.List(0) = "0.010"        'Populate Det 1 current range 10 mA
    cboDet1CurrRng.List(1) = "0.020"        'Populate Det 1 current range 20 mA
    cboDet1CurrRng.List(2) = "0.050"        'Populate Det 1 current range 50 mA
    cboDet1CurrRng.List(3) = "0.100"        'Populate Det 1 current range 100 mA
    cboDet1CurrRng.ListIndex = 0            'Set Detector current measure range to 10 mA
    cboDet1CurrRng.Enabled = False          'Lock in Detector current measure range
    txtDet1Bias.Text = 0                    'Set detector bias voltage to zero (no bias for resistor DUT)
    txtDet1Bias.Enabled = False             'Lock in (disable) bias voltage setting
    'Detector 2
    cboDet2CurrRng.List(0) = "0.010"        'Populate Det 1 current range 10 mA
    cboDet2CurrRng.List(1) = "0.020"        'Populate Det 1 current range 20 mA
    cboDet2CurrRng.List(2) = "0.050"        'Populate Det 1 current range 50 mA
    cboDet2CurrRng.List(3) = "0.100"        'Populate Det 1 current range 100 mA
    cboDet2CurrRng.ListIndex = 0            'Set Detector current measure range to 10 mA
    cboDet2CurrRng.Enabled = False          'Lock in Detector current measure range
    txtDet2Bias.Text = 0                    'Set detector bias voltage to zero (no bias for resistor DUT)
    txtDet2Bias.Enabled = False             'Lock in (disable) bias voltage setting

'Set Pulse Transition State to fast
    PulseTrans = 0                          '0=Fast, 1=slow (slow=turn on is intentionally slowed down to a fixed setting of 5e-6)

'Populate Pulse Width and Delay combo boxes and initial displayed value
'Set Pulse Width (pulse on time) values, displayed in units of us
    cboPulseWidth.List(0) = "0.5"           '500 ns
    cboPulseWidth.List(1) = "1.0"           '1 us
    cboPulseWidth.List(2) = "2.0"           '2 us
    cboPulseWidth.List(3) = "5.0"           '5 us
    cboPulseWidth.List(4) = "10.0"          '10 us
    cboPulseWidth.List(5) = "100.0"         '100 us
    cboPulseWidth.ListIndex = 2             'set default (displayed) value
'    PulseWidth = Val(cboPulseWidth.Text) / 1000000# 'Initialize variable, divide by 1xE6 to get actual value
'Set Pulse Delay (pulse off time) values, displayed in units of us
    cboPulseDelay.List(0) = "20"            '20 ns
    cboPulseDelay.List(1) = "50"            '50 us
    cboPulseDelay.List(2) = "100"           '100 us
    cboPulseDelay.List(3) = "200"           '200 us
    cboPulseDelay.List(4) = "500"           '500 us
    cboPulseDelay.List(5) = "1000"          '1 ms
    cboPulseDelay.List(6) = "5000"          '5 ms
    cboPulseDelay.List(7) = "10000"         '10 ms
    cboPulseDelay.ListIndex = 2             'set default (displayed) value

'Populate V measure combo box for Laser Diode (Channel 1)
    cboVmeas.List(0) = "5"                  'First value is 5 V
    cboVmeas.List(1) = "10"                 'Second range is 10 V
    cboVmeas.ListIndex = 0                  'Set default& displayed value to 5V

'Populate 2510 TEC control temperature combo box
    cboSetpoint.List(0) = "10"              'Setpoint choice = 10C
    cboSetpoint.List(1) = "15"              'Setpoint choice = 15C
    cboSetpoint.List(2) = "20"              'Setpoint choice = 20C
    cboSetpoint.List(3) = "25"              'Setpoint choice = 25C
    cboSetpoint.List(4) = "30"              'Setpoint choice = 30C
    cboSetpoint.List(5) = "35"              'Setpoint choice = 35C
    cboSetpoint.List(6) = "40"              'Setpoint choice = 40C
    cboSetpoint.ListIndex = 3               'Set diplayed value to 25C
    
'Initialize Variables Settings
optDUTtype(0).value = True                  'Set ranges for sweep (start, stop, step currents), Det channel ranges and bias for 500 mA DUT
optOutputMode(0).value = True               'initialize to Sweep Mode
optShape(0).value = True                    'Initialize Output Shape (Pulse or DC) to Pulse
bln2520Output = False                       'Initialize 2520 Output variable
Det1Polarity = 1                            'Initialize to positive polarity for curr meas
Det2Polarity = 1                            'Initialize to positive polarity for curr meas

'Set up all Tool Tip Texts
txtDuty.ToolTipText = "Duty % = Width / (Width + Delay) * 100. Max Duty Cycle is 4% for >1 A"
lblDuty.ToolTipText = "Duty % = Width / (Width + Delay) * 100. Max Duty Cycle is 4% for >1 A"
cboPulseDelay.ToolTipText = "This is the delay between pulses. Range: 20 usec to 500 ms, 10 us step"
lblPulseDelay.ToolTipText = "aka Pulse Delay. Range: 20 usec to 500 ms, 10 us step"
cboPulseWidth.ToolTipText = "Pulse ON time. Range: 500 ns to 5 ms, 100 ns step"
lblPulseWidth.ToolTipText = "Pulse ON time. Range: 500 ns to 5 ms, 100 ns step"
optDUTtype(0).ToolTipText = "DUT has 16.7 ohm resistance (nominal) across pulse crkt. No Det Bias allowed."  '500 mA resistor DUT
optDUTtype(1).ToolTipText = "DUT has 1.6 ohm resistance (nominal) across pulse crkt. No Det Bias allowed."    '5A resistor DUT
optDUTtype(2).ToolTipText = "Expert mode permits testing of devices with additional instrument control."              'Expert mode, no tool tip
lblDet1Bias.ToolTipText = "Det 1 Voltage Bias: -20 to +20 V"
txtDet1Bias.ToolTipText = "Det 1 Voltage Bias: -20 to +20 V"
lblDet2Bias.ToolTipText = "Det 2 Voltage Bias: -20 to +20 V"
txtDet2Bias.ToolTipText = "Det 2 Voltage Bias: -20 to +20 V"
fraDetBias.ToolTipText = "Voltage Bias: -20 to +20 V"
chkSaveData.ToolTipText = "Check box to bring up Save Data Dialog Box when Sweep is run"
optKinkTest(0).ToolTipText = "Detector 1 is typically connected to Front Facet detector"
optKinkTest(1).ToolTipText = "Detector 2 is typically connected to Back Facet detector"
optOutputMode(1).ToolTipText = "DC current"
fraDUT.ToolTipText = "Device Under Test"
lblMeasureWarn.Caption = "This demo program does not collect measurements during fixed current Pulse or fixed current DC modes."
lblSteps.ToolTipText = "Maximum number of steps in a sweep: 1000"
lblStep.ToolTipText = "Minimum Step size: 10 uA (500 mA range), 100 uA (5A range).  Step size cannot cause >1000 points in a sweep."

End Sub


Private Sub Form_Load()
'Determine available GPIB card
intKI2520 = 20                              'Default GPIB address = 20
intKI2510 = 10                              'Default GPIB address = 10
strSetFile = "2520Demo.txt"                 'Filename for storing demo program settings

'Position form on screen
'Left = (Screen.width - width) / 2   ' Center form horizontally.
'Top = (Screen.Height - Height) / 2  ' Center form vertically.
Left = 100                 'Position form upper left
Top = 0                 'Position form upper left

'Below code is not yet functional
'CheckGPIB:
'    ' Configure GPIB
'    On Error GoTo NoCEC
'    If Dir$(Environ$("windir") + "\ieee_32m.dll") <> "" Or Dir$(Environ$("windir") + "\system\ieee_32m.dll") <> "" Or Dir$(Environ$("windir") + "\system32\ieee_32m.dll") <> "" Then
'        initialize 21, 0                    'Initialize CEC GPIB controller, GPIB Address=21
'        setoutputEOS 10, 0
'        setinputEOS 10
'        settimeout 10000                            'Set GPIB timeout to 10 s
'        frmGPIBSettings.CommOpt(0).Enabled = True
'        frmGPIBSettings.CommOpt(0).value = True
'        frmMain.CommOpt(0).Enabled = frmGPIBSettings.CommOpt(0).Enabled
'        frmMain.CommOpt(0).value = frmGPIBSettings.CommOpt(0).value
'    Else
'        frmGPIBSettings.CommOpt(0).value = False
'        frmGPIBSettings.CommOpt(0).Enabled = False
'        frmMain.CommOpt(0).value = frmGPIBSettings.CommOpt(0).value
'        frmMain.CommOpt(0).Enabled = frmGPIBSettings.CommOpt(0).Enabled
'    End If
'
'    On Error GoTo NoNI4882
'    If Dir(Environ$("windir") + "\gpib-32.dll", 0) <> "" Or Dir(Environ$("windir") + "\system\gpib-32.dll", 0) <> "" Or Dir(Environ$("windir") + "\system32\gpib-32.dll", 0) <> "" Then
'        frmGPIBSettings.CommOpt(1).Enabled = True
'        frmGPIBSettings.CommOpt(1).value = True
'        frmMain.CommOpt(1).value = frmGPIBSettings.CommOpt(1).value
'        frmMain.CommOpt(1).Enabled = frmGPIBSettings.CommOpt(1).Enabled
'        Call SendIFC(BRDNUM)
'        Call ibtmo(BRDNUM, T10s)                    'Set GPIB timeout to 10 s
'        Call ibsre(BRDNUM, 1)
'    Else
'        frmGPIBSettings.CommOpt(1).value = False
'        frmGPIBSettings.CommOpt(1).Enabled = False
'        frmMain.CommOpt(1).value = frmGPIBSettings.CommOpt(1).value
'        frmMain.CommOpt(1).Enabled = frmGPIBSettings.CommOpt(1).Enabled
'    End If


'Set default GPIB card (to override above code, which doesn't seem to choose CEC well)
'frmGPIBSettings.CommOpt(0).value = True
'frmGPIBSettings.CommOpt(0).Enabled = True
'frmMain.CommOpt(0).value = frmGPIBSettings.CommOpt(0).value
'frmMain.CommOpt(0).Enabled = frmGPIBSettings.CommOpt(0).Enabled

Call GetSettings                    'Retrieve settings from file

Exit Sub

NoCEC:
    frmGPIBSettings.CommOpt(0).value = False
    frmGPIBSettings.CommOpt(0).Enabled = False
    Resume Next
    
NoNI4882:
    frmGPIBSettings.CommOpt(1).Enabled = False
    Resume Next

End Sub

Private Sub lblMeasureWarn_Click()
'MsgBox "This demo program does not support a For an infinite train of fixed current pulses, the 2520 does not measure." & _
'        vbCrLf & "But, a 1000 point (fixed-current) pulse sweep can be programmed" & _
'        vbCrLf & "(measurements will be made at each point of the sweep)." & _
'        vbCrLf & vbCrLf & "For DC current, readings can be made periodically."
End Sub

Private Sub mnuAbout_Click()
'Display About form

frmAbout.Show

End Sub

Private Sub mnuGPIBSettings_Click()
'Bring up GPIB settings form

frmGPIBSettings.Show vbModal

End Sub

Private Sub mnuQuit_Click()
    Unload frmMain
End Sub

Public Sub Form_Unload(Cancel As Integer)
    Cancel = MsgBox("Exit?", 20, "Exit Verify")         'Confirm exit
'    If Cancel = 6 Then
'        Quit = True
'    Else
'        Quit = False
'    End If
If Cancel = 6 Then              'Quit application was chosen, close all potentially open forms
    Unload frmSweepChart
    Unload frmPulseChart
    End                         'Stop program execution
End If

End Sub
Private Sub SetRange(Index As Integer)
'This routine populates/customizes combo boxes for Sweep Current (start, stop, step)
'and set max values for the chosen range/DUT
'Enable/disable controls as necessary, based on DUT type

Select Case Index       'Index is from optDUTtype() array

Case 0                  'Unique settings for the 500 mA Resistor DUT

    'Populate combo boxes for Sweep Current (start, stop, step)
    'Note that Case 0 is also the default case, so it also is the initialization for the combo boxes
    'Populate StartCurrent
    cboStartCurrent.List(0) = "0.001"               '1mA start current
    cboStartCurrent.List(1) = "0.010"               '10 mA
    cboStartCurrent.List(2) = "0.100"
    cboStartCurrent.List(3) = "0.200"
    cboStartCurrent.ListIndex = 0            'Choose 2nd value in list for default value

    'Populate Stop Current
    cboStopCurrent.List(0) = "0.050"         'set drop-down values for sweep Stop Current
    cboStopCurrent.List(1) = "0.100"
    cboStopCurrent.List(2) = "0.200"
    cboStopCurrent.List(3) = "0.500"          'Max current for 500 mA DUT = 500 mA
    cboStopCurrent.ListIndex = 1              'Set displayed (default) value to the 2nd value in the list
    If cboStopCurrent.ListCount > 4 Then      'If 5A range values are present, remove them from StopCurrent
        cboStopCurrent.RemoveItem 6           'Remove values that are too large for 500 mA DUT
        cboStopCurrent.RemoveItem 5           'Remove values that are too large for 500 mA DUT
        cboStopCurrent.RemoveItem 4           'Remove values that are too large for 500 mA DUT
    End If

    'Set Fixed (DC) current default (Amps)
    txtDCcurrent.Text = "0.075"

    'Populate Detector Channel text and combo boxes (Voltage Bias, Detector channel current measure range and polarity)
    cboDet1CurrRng.ListIndex = 0            'Set Detector current measure range to 10 mA
    cboDet1CurrRng.Enabled = False          'Lock in Detector current measure range
    cboDet2CurrRng.ListIndex = 0            'Set Detector current measure range to 10 mA
    cboDet2CurrRng.Enabled = False          'Lock in Detector current measure range
    txtDet1Bias.Text = 0                    'Set detector bias voltage to zero (no bias permitted for resistor DUTs)
    txtDet1Bias.Enabled = False             'Lock (disable) bias voltage setting
    txtDet2Bias.Text = 0                    'Set detector bias voltage to zero (no bias permitted for resistor DUTs)
    txtDet2Bias.Enabled = False             'Lock (disable) bias voltage setting
    optDet1Polarity(1).value = True         'Set Det 1 to positive polarity
    optDet2Polarity(1).value = True         'Set Det 2 to positive polarity
    optDet1Polarity(0).Enabled = False      'Lock polarity settings for resistor DUT
    optDet1Polarity(1).Enabled = False      'Lock polarity settings
    optDet2Polarity(0).Enabled = False      'Lock polarity settings
    optDet2Polarity(1).Enabled = False      'Lock polarity settings
    
    'Set measurement ranges
    CurrentMax = 0.5                         'set max Pulse start current to max for this DUT
    FixedCurrentMax = 0.5                     'set max DC current to 500 mA
    SweepStepMin = 0.000001                   'set min current sweep step to 10 uA
    
    'Disable Kink test choice, since resistor DUT has only 1 effective Det channel
    optKinkTest(0).Enabled = False
    optKinkTest(1).Enabled = False
    fraKinkTest.ToolTipText = "Resistor DUT effectively has only 1 detector channel."
    
    'Hide 2510 control frame because there's no TEC in resistor DUT
    fra2510.Visible = False
    frmGPIBSettings.fra2510GPIB.Visible = False 'Hide 2510 frame on GPIB form
    
Case 1              '5 A Resistor DUT
    
    'Populate Stop Current combo box
    cboStopCurrent.List(4) = "1.000"          'Add drop-down values for sweep stop current
    cboStopCurrent.List(5) = "2.000"
    cboStopCurrent.List(6) = "5.000"
    cboStopCurrent.ListIndex = 4            'Set displayed (default) value to the 2nd value in the list
    
    'Populate Detector Channel text and combo boxes (Voltage Bias, Detector channel current measure)
    cboDet1CurrRng.ListIndex = 0            'Set Detector current measure range to 10 mA
    cboDet1CurrRng.Enabled = False          'Lock in Detector current measure range
    cboDet2CurrRng.ListIndex = 0            'Set Detector current measure range to 10 mA
    cboDet2CurrRng.Enabled = False          'Lock in Detector current measure range
    txtDet1Bias.Text = 0                    'Set detector bias voltage to zero (no bias permitted for resistor DUTs)
    txtDet1Bias.Enabled = False             'Lock (disable) bias voltage setting
    txtDet2Bias.Text = 0                    'Set detector bias voltage to zero (no bias permitted for resistor DUTs)
    txtDet2Bias.Enabled = False             'Lock (disable) bias voltage setting
    optDet1Polarity(1).value = True         'Set Det 1 to positive polarity
    optDet2Polarity(1).value = True         'Set Det 2 to positive polarity
    optDet1Polarity(0).Enabled = False      'Lock polarity settings for resistor DUT
    optDet1Polarity(1).Enabled = False      'Lock polarity settings
    optDet2Polarity(0).Enabled = False      'Lock polarity settings
    optDet2Polarity(1).Enabled = False      'Lock polarity settings
    
    'Set Fixed (DC) current default (A)
    txtDCcurrent.Text = "1.750"
    
    'Set measurement ranges for 5A resistor DUT
    CurrentMax = 5#                         'set max Pulse current to 5A for this range
    FixedCurrentMax = DCCurrentMax          'Set max DC current to DCcurrentmax (1A), which is 2520 maximum DC
    SweepStepMin = 0.00001                   'set min current sweep step to 100 uA
    
    'Disable Kink test choice, since resistor DUT has only 1 effective Det channel
    optKinkTest(0).Enabled = False           'enable Kink test choice             'Disable Kink test choice, since resistor DUT has only 1 effective Det channel
    optKinkTest(1).Enabled = False
    fraKinkTest.ToolTipText = "Resistor DUT effectively has only 1 detector channel."
    
    'Hide 2510 control frame because there's no TEC in resistor DUT
    fra2510.Visible = False
    frmGPIBSettings.fra2510GPIB.Visible = False 'Hide 2510 frame on GPIB form
    
Case 2                                      'Expert Mode Settings
    
    MsgBox "WARNING.  There is minimal parameter checking and control" & _
            vbCrLf & "                      in this mode.  It's possible to damage DUTs or" & _
            vbCrLf & "                      collect incorrect data. Please exercise caution.", vbExclamation, "WARNING: Expert Mode"
    
    txtDet1Bias.Text = 0                    'Set detector bias voltage for speediest photodiode response
    txtDet2Bias.Text = 0                    'Set detector bias voltage for speediest photodiode response
    txtDet1Bias.Enabled = True              'Enable bias voltage setting
    txtDet2Bias.Enabled = True              'Enable bias voltage setting
    optDet1Polarity(0).Enabled = True       'Enable polarity settings for resistor DUT
    optDet1Polarity(1).Enabled = True       'Enable polarity settings
    optDet2Polarity(0).Enabled = True       'Enable polarity settings
    optDet2Polarity(1).Enabled = True       'Enable polarity settings
    optDet1Polarity(0).value = True         'Set Det1 to neg polarity for Trade Show Demos
    cboDet1CurrRng.Enabled = True           'Enable Detector current measure range
    cboDet2CurrRng.Enabled = True           'Enable Detector current measure range
    cboStopCurrent.List(4) = "1.000"        'Add drop-down values for sweep stop current
    cboStopCurrent.List(5) = "2.000"
    cboStopCurrent.List(6) = "5.000"
    cboStopCurrent.ListIndex = 4            'Set displayed (default) value to the 2nd value in the list
    cboStopCurrent.Text = "1.000"           'Default value for sweep stop current
    
    'Set Fixed (DC) current default (Amps)
    txtDCcurrent.Text = "0.100"
    
    'Set measurement ranges
    CurrentMax = 5#                          'Set to max range 2520
    FixedCurrentMax = 1#               '?? Need proper max DC current for LED
    SweepStepMin = 0.000001                    '??set min current sweep step to 10 uA
    
    'Enable Kink Test choices,
'    optKinkTest(0).Enabled = True              'Commented out, feature not enabled
'    optKinkTest(1).Enabled = True
'    fraKinkTest.ToolTipText = ""                'Clear Tool tip text
    
    'Enable 2510 control frame
    fra2510.Visible = True
    frmGPIBSettings.fra2510GPIB.Visible = True
    
End Select

SweepStopMax = CurrentMax                     'Set limits to max
SweepStartMax = SweepStopMax - 0.005          'Set maximum sweep start current to StopMax - 5 mA
Call ValidateAll                              'Ensure that values are OK

End Sub

Public Sub Save_Click()
'This routine will save data to disk in CSV (comma separated value) format
'This demo program only saves sweep data

'Declare local variable
Dim i As Integer
Dim str2520IRange As String
Dim str2520VRange As String
Dim strIPolarity As String
Dim strVPolarity As String
Dim strShape As String
Dim strMode As String
Dim strDet1Polarity As String
Dim strDet2Polarity As String
Dim strSweepStart As String
Dim strSweepStop As String
Dim strSweepStep As String

' Set CancelError is True
CommonDialog1.CancelError = True
On Error GoTo ErrHandler
' Set flags
CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNOverwritePrompt
' Set filters
CommonDialog1.Filter = "CSV Files (*.CSV)|*.csv"
' Specify default filter
CommonDialog1.FilterIndex = 1
' Display the Open dialog box
CommonDialog1.ShowSave

If SendKI(intKI2520, ":sour:curr:rang?") Then Exit Sub      'Query source current range
str2520IRange = QueryKI(intKI2520)                          'Retrieve data
   
If SendKI(intKI2520, ":sens1:volt:rang?") Then Exit Sub     'Query laser diode V measure range
str2520VRange = QueryKI(intKI2520)                          'Retrieve data
  
If SendKI(intKI2520, ":sour:func:shap?") Then Exit Sub      'Query source current shape (PULSe or DC)
strShape = QueryKI(intKI2520)                               'Retrieve data
  
If chkSinglePulse.value = True Then         'Determine if in sweep or single pulse mode
    strMode = "Single"
    Else
    strMode = "Sweep"
End If
    
If SendKI(intKI2520, ":sens2:curr:pol?") Then Exit Sub      'Query Detector channel 1 current measure polarity
strDet1Polarity = QueryKI(intKI2520)                        'Retrieve data
   
If SendKI(intKI2520, ":sens3:curr:pol?") Then Exit Sub      'Query Detector channel 2 current measure polarity
strDet2Polarity = QueryKI(intKI2520)                        'Retrieve data
    
If SendKI(intKI2520, ":sens1:volt:pol?") Then Exit Sub      'Query laser diode voltage measure polarity
strVPolarity = QueryKI(intKI2520)                        'Retrieve data
   
If SendKI(intKI2520, ":sour:curr:pol?") Then Exit Sub       'Query laser diode current source polarity
strIPolarity = QueryKI(intKI2520)                        'Retrieve data
    
If SendKI(intKI2520, ":sour:curr:star?") Then Exit Sub      'Query current sweep start value
strSweepStart = QueryKI(intKI2520)                          'Retrieve data
    
If SendKI(intKI2520, ":sour:curr:stop?") Then Exit Sub      'Query current sweep stop value
strSweepStop = QueryKI(intKI2520)                           'Retrieve data
    
If SendKI(intKI2520, ":sour:curr:step?") Then Exit Sub      'Query current sweep step size value
strSweepStep = QueryKI(intKI2520)                           'Retrieve data
    
Open CommonDialog1.filename For Output As #1
Print #1, Date, ",", Time
Print #1, txtComments
Print #1, "2520 Source settings:"
Print #1, strShape & " " & strMode, ",I Source Polarity = ,", strIPolarity, ",V Measure Polarity = ,", strVPolarity
If strShape = "PULS" Then                  'Only save Pulse data if in pulse mode
    Print #1, "Pulse Width (s) = ,", PulseWidth, ",Pulse Delay (s) = ,", PulseDelay
End If
Print #1, "Start I (A) = ,", strSweepStart, ",Stop I (A) = ,", strSweepStop, ",Step I (A) = ,", strSweepStep
Print #1, "I Source Range (A) = ,", str2520IRange, ",V Meas Range (V) = ,", str2520VRange
Print #1, "2520 Detector settings:"
Print #1, "Det1 I Range (A) = ,", cboDet1CurrRng.Text, ",Det1 V Bias (V) = ,", Det1Bias, ",Det1 Polarity = ,", strDet1Polarity
Print #1, "Det2 I Range (A) = ,", cboDet2CurrRng.Text, ",Det2 V Bias (V) = ,", Det2Bias, ",Det2 Polarity = ,", strDet2Polarity
Print #1,
Print #1, "LD Curr,LD Volt,Det1 Curr,Det2 Curr,2nd Deriv,1st Deriv"

For i = 1 To intSteps
    strdata = dblArray(intLDCurr, i) & ","
    strdata = strdata & dblArray(intLDVolt, i) & ","
    strdata = strdata & dblArray(intDet1Curr, i) & ","
    strdata = strdata & dblArray(intDet2Curr, i) & ","
    strdata = strdata & dblArray(int2ndDeriv, i) & ","
    strdata = strdata & dblArray(int1stDeriv, i) & ","
'        If i > 1 Then
'            strdata = strdata & (dblArray(intDet1Curr, i) - dblArray(intDet1Curr, i - 1)) / (CSng(SweepStep)) & ","
'            strdata = strdata & (dblArray(intDet2Curr, i) - dblArray(intDet2Curr, i - 1)) / (CSng(SweepStep))
'        Else
'            strdata = strdata & 0 & ","
'            strdata = strdata & 0
'        End If
        Print #1, strdata
    Next i
    Close #1

If CommonDialog1.filename <> "" Then                'If filename not blank, then store name and set SaveFileLoaded to true
        SaveFileName = CommonDialog1.filename
        SaveFileLoaded = True
    End If
  
  Exit Sub

ErrHandler:
    'User pressed the Cancel button, file already exists, etc
    'add error handling routine here

SaveFileLoaded = False

Select Case Err.Number

Case 75
        MsgBox "Cannot open specified output file", vbExclamation

Case 70
        MsgBox "Permission Denied.  File is already open.  Choose another file name.", vbExclamation
        Call Save_Click

Case cdlCancel
    Exit Sub
   
Case Else
    MsgBox Err.Description, , "Error Description"
    MsgBox Err.Number


End Select

End Sub

Private Sub optDet1Polarity_Click(Index As Integer)
'Determine Polarity of Det1 current measurement

Det1Polarity = Index                            '1=positive, 0=negative

End Sub

Private Sub optDet2Polarity_Click(Index As Integer)
'Determine Polarity of Det2 current measurement

Det2Polarity = Index                            '1=positive, 0=negative

End Sub

Private Sub optDUTtype_Click(Index As Integer)

Call SetRange(Index)                        'Set sweep params (start, stop, step), Det params (range, bias)
                                            'based on type of DUT
                                            
End Sub

Private Sub optOutputMode_Click(Index As Integer)
'This procedure enables/disables the Sweep controls, either Pulse or Fixed
'Also labels the cmdOutputOnOff to reflect chosen mode

'Debug code below
'Call OutputOff                              'Ensure that 2520 Output is off

Select Case Index                   'O=Sweep, 1=Fixed

Case 0                  'Mode = Sweep (either pulse or Fixed (DC))

        txtDCcurrent.Enabled = False                'If mode is Sweep, disable DC text box input
        lblDCcurrent.Enabled = False
        lblFixed.Enabled = False
        cboStartCurrent.Enabled = True              'If mode is Sweep then enable sweep combo boxes
        cboStopCurrent.Enabled = True
        cboStepCurrent.Enabled = True
        lblStart.Enabled = True
        lblStop.Enabled = True
        lblStep.Enabled = True
        lblSteps.Enabled = True
        txtSteps.Enabled = True
        imgPulseSweep.Enabled = True
        imgDCsweep.Enabled = True
        chkSinglePulse.value = False                'Ensure that Single Pulse is unchecked
        chkSinglePulse.Enabled = False              'Not in Fixed (DC) mode, so disable Single Pulse
        cmdOutputOnOff.Caption = "Start Sweep"      'Label button for Sweep operation
        cmdOutputOnOff.ToolTipText = ""             'For sweep mode, clear tooltip text
        shpOutputStatus.FillColor = &HC0C0C0        'Change Output ON/Off indicator back to grey
        fraMeasureRange.Visible = True              'Display Vmeasure and Det Current Range controls when in Sweep
        chkSaveData.Enabled = True                  'Enable save data checkbox
        lblMeasureWarn.Visible = False                 'Hide Measure Warning Text, because sweep mode permits saving data

Case 1          'Mode = Fixed (DC current or constant Pulse)

        txtDCcurrent.Enabled = True                 'If mode is fixed (DC) then enable text box to set current
        lblDCcurrent.Enabled = True
        lblFixed.Enabled = True
        cboStartCurrent.Enabled = False       'If mode is Fixed (DC) then disable sweep combo boxes
        cboStopCurrent.Enabled = False
        cboStepCurrent.Enabled = False
        lblStart.Enabled = False
        lblStop.Enabled = False
        lblStep.Enabled = False
        lblSteps.Enabled = False
        txtSteps.Enabled = False
        imgPulseSweep.Enabled = False
        imgDCsweep.Enabled = False
        cmdOutputOnOff.Caption = "Output On"      'Label Output button for Fixed (DC) operation
        cmdOutputOnOff.ToolTipText = "Press to turn 2520 Output ON"
        chkSaveData.Enabled = False                 'disable save data checkbox (no data saved if not in pulse)
        lblMeasureWarn.Visible = True               'Display Measure Warning Text
        If optShape(0).value Then                   'If Pulse and Fixed is chosen, then enable Single Pulse mode
            chkSinglePulse.Enabled = True
        Else
            chkSinglePulse.Enabled = False
        End If

End Select

End Sub

Private Sub optShape_Click(Index As Integer)
'This procedure enables/disables the sweep or DC controls, based on user choice

'Call OutputOff                              'Ensure that 2520 Output is off
If optShape(0).value Then                   'If Shape is Pulse, then enable the Pulse width and delay combo boxes
        cboPulseWidth.Enabled = True
        cboPulseDelay.Enabled = True
        lblPulseWidth.Enabled = True
        lblPulseDelay.Enabled = True
        lblmS(0).Enabled = True
        lblmS(1).Enabled = True
        lblDuty.Enabled = True
        txtDuty.Enabled = True
        lblPercent.Enabled = True
        frmSweepChart.txtPulseWidth.Visible = True                    'Display value
        frmSweepChart.lblPulseWidth.Visible = True                    'Display label
        frmSweepChart.lblPulseDelay.Visible = True                    'Display label
        frmSweepChart.txtPulseDelay.Visible = True                    'Display value
        imgPulseSweep.Visible = True                                  'Display pulse sweep image
        imgDCsweep.Visible = False                                    'Hide DC Sweep image
        imgPulseFixed.Visible = True                                  'Display Pulse Fixed image
        imgDCFixed.Visible = False                                     'Hide DC Fixed output image
        lblFixed.Caption = "Pulse Amplitude"                                'Set label for Constant current pulsing
        OutputShape = 1                                                 'Set Outputshape to 1=Pulse mode
        If optOutputMode(1).value Then                                  'If in Fixed Current mode, Enable Single Pulse
            chkSinglePulse.Enabled = True
        End If
        
        Else                    'If Shape is DC, then disable pulse combo boxes
        cboPulseWidth.Enabled = False
        cboPulseDelay.Enabled = False
        lblPulseWidth.Enabled = False
        lblPulseDelay.Enabled = False
        lblmS(0).Enabled = False
        lblmS(1).Enabled = False
        lblDuty.Enabled = False
        txtDuty.Enabled = False
        lblPercent.Enabled = False
        frmSweepChart.txtPulseWidth.Visible = False           'Make pulse info invisible on Sweep Chart
        frmSweepChart.lblPulseWidth.Visible = False           'Make pulse info invisible on Sweep Chart
        frmSweepChart.lblPulseDelay.Visible = False
        frmSweepChart.txtPulseDelay.Visible = False
        imgPulseSweep.Visible = False                                  'Hide pulse sweep image
        imgDCsweep.Visible = True                                      'Display DC Sweep image
        imgPulseFixed.Visible = False                                  'Hide Pulse Fixed image
        imgDCFixed.Visible = True                                       'Display DC Fixed output image
        lblFixed.Caption = "DC Current"                                 'Set label for DC fixed current output
        OutputShape = 2                                                 'Set Outputshape to 2=DC mode
        chkSinglePulse.Enabled = False                      'In Fixed (DC) mode not Pulse, so disable Single Pulse
        chkSinglePulse.value = False                        'Uncheck Single Pulse value because we're in DC Shape mode
    End If

Call ValidateAll

End Sub

Private Function CheckInput(value As Variant, Min As Single, Max As Single) As Single
'This routine compares the input Value for a variable to the Min and
'Max values.  If the input Value is greater/less than the max/min, this
'routine will coerce the value to the appropriate limit
'Inputs:    Value, Min, Max
'Outputs:   Range-bounded Function return

If Val(value) >= Min And Val(value) <= Max And value <> "" Then
'        Output = Val(txtDet1Bias.Text)
'    ElseIf value = "" Then Output = 0#      'If no value is entered, make the Value=0
    ElseIf value = "" Then value = Min      'If no value is entered, make the Value=min
            ElseIf Val(value) > Max Then
                value = Max
            ElseIf Val(value) < Min Then
                value = Min
 End If

CheckInput = Val(value)          'Set function return value to range-coerced value, val() converts string to numeric

End Function


Private Sub txtDCcurrent_Validate(Cancel As Boolean)
'Check DC (Fixed) Current value

Call ValidateAll

End Sub

Private Sub txtDet1Bias_Validate(Cancel As Boolean)
'Ensure that -20 V <= bias voltage <= 20 V, which is the range of the 2520

Call ValidateAll

End Sub

Private Sub txtDet2Bias_Validate(Cancel As Boolean)
'Ensure that -20 V <= bias voltage <= 20 V, which is the range of the 2520

Call ValidateAll

End Sub

Public Function CalcDutyCycle(width As Single, delay As Single) As Double
'This function calculates and returns the Duty Cycle of the Pulse
'2520 Max duty cycle is 4% for current >1 A

CalcDutyCycle = 100 * (width / (width + delay)) 'Calculate Duty Cycle %

If CalcDutyCycle > 4# And optShape(0).value And (Val(txtDCcurrent.Text) > 1# Or Val(cboStopCurrent.Text) > 1#) Then       'If in Pulse Mode and current > 1 A, Duty Cycle max is 4%
    MsgBox "Duty Cycle > 4%, which is the maximum for current > 1.0 A", vbOKOnly, "Maximum Duty Cycle Exceeded"
    cmdOutputOnOff.Enabled = False              'Disable outputOn/Off button for Duty Cycle > 4%
 Else
    cmdOutputOnOff.Enabled = True               'Enable outputOn/Off button for Duty Cycle , 4%
End If

End Function

Public Sub ValidateAll()
'This procedure validates all text values on the main form, because using individual _Validation
'procedures for each control gets confusing with multiple dependencies
'NOTE:  Validate Event and CausesValidation Property were first made
'available in VB6
'If using VB <6, then use control_LostFocus and control_Change
'which are roughly equivalent, but note that entering decimal values has issues
'NOTE: The order of validation of the variables is important in some cases

Dim MaxI As Single                'Local variable for validation


'Check and coerce the Sweep Stop current for all modes
SweepStop = CheckInput(cboStopCurrent.Text, Val(SweepStartMin), SweepStopMax)
cboStopCurrent.Text = SweepStop

'Check and coerce the Sweep Start current for all modes
SweepStart = CheckInput(cboStartCurrent.Text, SweepStartMin, Val(cboStopCurrent.Text))
cboStartCurrent.Text = SweepStart

'Make sure that total sweep range is at least 5 mA
If (SweepStop - SweepStart) < 0.005 Then                     'Is total sweep < 5 mA?, if so change start or stop to get min 5 mA
    If SweepStart > 0.005 Then                              'If SweepStart > 10 mA, lower Sweepstart to SweepStartMin
        SweepStart = SweepStart - 0.005
        cboStartCurrent.Text = SweepStart                   'Update displayed value
    Else                                                     'If SweepStart already low, then add 5 mA to SweepStop
        SweepStop = SweepStop + 0.005
        cboStopCurrent.Text = SweepStop
    End If
End If

'Ensure fixed current is within limits
'For 5A Resistor DUT & Expert Mode, note that Pulse Current
'max(5A) is different from the fixed (DC) current max of 1A

If optShape(1).value Then                               'Mode is Fixed (not Pulse)
    MaxI = FixedCurrentMax
    Else
    MaxI = CurrentMax                             'Pulse mode
End If
FixedCurrent = CheckInput(Val(txtDCcurrent), 0, MaxI)
txtDCcurrent.Text = FixedCurrent

'Check laser diode V measure range (control=cboVmeas), if current is too high
'(>300 mA on 500 mA DUT(16.7 ohm) or >3.0A on 5A DUT(1.6 ohm)) then set to 10V
'NOTE:  The use of DUTtype(0) and DUTtype(1) are used to ensure that Expert
'       mode does not have the below voltage range check applied.

If optOutputMode(0).value Then          'First get maximum current requested
    MaxI = SweepStop                    'in sweep mode, so max current is Sweepstop
    Else
    MaxI = FixedCurrent                 'in Fixed mode, so max current is Fixedcurrent
    End If
If (optDUTtype(0) And MaxI > 0.3) Or (optDUTtype(1) And MaxI > 3#) Then
    cboVmeas.ListIndex = 1          'Set to 10 V measure range

Else                'If both DUT types are below 10V, then use 5V
        If (optDUTtype(0) And MaxI <= 0.3) Or (optDUTtype(1) And MaxI <= 3#) Then
        cboVmeas.ListIndex = 0      'Set to 10 V measure range
        End If
End If

'Determine Proper Current Source Range (either 500 mA or 5A)
If MaxI <= 0.5 Then
    CurrentRange = 0    'Max required current output <= 500 mA
    Else
    CurrentRange = 1
End If

'Validate Detector 1 voltage bias
Det1Bias = CheckInput(txtDet1Bias.Text, VBiasMin, VBiasMax)
txtDet1Bias.Text = Det1Bias

'Validate Detector 2 voltage bias
Det2Bias = CheckInput(txtDet2Bias.Text, VBiasMin, VBiasMax)
txtDet2Bias.Text = Det2Bias

'Ensure that Pulse Width is within acceptable limits
PulseWidth = CheckInput(cboPulseWidth.Text, PulseWidthMin, PulseWidthMax)
cboPulseWidth.Text = PulseWidth                         'Set displayed value to validated value
PulseWidth = (cboPulseWidth.Text / 1000000#) 'Divide microsecond value to get seconds

'Ensure that Pulse Delay (i.e., Pulse off time )is within
'acceptable limits and calculate Duty Cycle
PulseDelay = CheckInput(cboPulseDelay.Text, PulseDelayMin, PulseDelayMax)
cboPulseDelay.Text = PulseDelay
PulseDelay = (cboPulseDelay.Text / 1000000#) 'Divide microsecond value to get seconds
txtDuty.Text = Round(CalcDutyCycle(Val(cboPulseWidth.Text), Val(cboPulseDelay.Text)), 3)


'Ensure that minimum sweep current step size is not too small
'and set value for SweepStep variable
If (cboStepCurrent.Text) < SweepStepMin Then cboStepCurrent.Text = (SweepStepMin)

'Here the value of the step size is checked.  To support dL/dI algorithm,
'the step is adjusted to provide at least 10 steps in the sweep.

SweepStep = Val(cboStepCurrent.Text)
If SweepStep > ((SweepStop - SweepStart) / 10) Then
SweepStep = (SweepStop - SweepStart) / 10
End If
cboStepCurrent.Text = SweepStep


'Here the number of steps in the sweep is calculated given start, stop,
'and step current values.  If the number of steps exceed 1000, then the
'number of steps is clamped to 1000 and the current step value is
'calculated to based on (stop-start)/1000.  This can cause "-222 Parameter Out of Range"
'error because of (lack of?) rounding resulting in a step size that is
'slightly too small (which would result in more than 1000 steps), but the
'2520 automatically rounds up the the appropriate step value to give 1000 points

intSteps = Int(1.01 + (SweepStop - SweepStart) / SweepStep)
If intSteps > 1000 Then
    intSteps = 1000
    SweepStep = (SweepStop - SweepStart) / 1000
    cboStepCurrent.Text = SweepStep
End If
txtSteps.Text = intSteps

'Ensure that desired TEC temperature setpoint is OK
Setpoint = CheckInput(Val(cboSetpoint.Text), -5, 70)      'Ensure that chosen setpoint is within -5 to 70C
cboSetpoint.Text = Setpoint                                 'Display validated setpoint

End Sub

Public Sub ConfigSweep2520()
'This procedure programs the 2520 with the chosen sweep parameters
'Measure parameters:  LD voltage measure polarity, LD current source polarity,
'Measure param cont'd: Det (1&2) curr meas polarity, Det (1&2) voltage source polarity
'Parameters:  SweepStart, SweepStop, SweepStep, PulseWidth, PulseDelay
       
'Initialise Ke2520, using VISA dll driver, and get session handle for 2520
'nErr = Ke2520_init("GPIB0::" & intKI2520 & "::INSTR", VI_ON, handle2520)   'GPIB: Reset 2520 and get handle
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, "*rst") Then Exit Sub


'CONFIGURE 2520
                
'Configure 2520 to send data in binary format (faster data transfer)
If SendKI(intKI2520, ":format:data sre;bord swap") Then Exit Sub    'send data from instrument in binary format
If SendKI(intKI2520, "form:elem curr1, volt1, curr2, curr3") Then Exit Sub  'Data returned:LD Current, LD voltage, Det1current, Det2 current
                
'Configure SRQ to occur on Sweep Done
If SendKI(intKI2520, ":stat:meas:enab 384") Then Exit Sub           'Mask Bit 8 (sweep done, 256) and bit 7 (sweep aborted, 128) of the Measurement Event Enable Register
If SendKI(intKI2520, "*sre 1") Then Exit Sub                        'mask "measurement summary bit" for SRQ
If SendKI(intKI2520, "*cls") Then Exit Sub                          'clear status register and queues, necessary for SRQ to function
                
'Detector Channel measurement params
'nErr = Ke2520_ConfigureSourceVoltageLevel(handle2520, 2, Det1Bias)  'Configure Source 2 Voltage Range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSourceVoltageLevel(handle2520, 3, Det2Bias)  'Configure Source 3 Voltage Range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSenseCurrent(handle2520, 2, cboDet1CurrRng.ListIndex + 1, Det1Polarity) 'Set Det1 (Sense 2) Current measure range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSenseCurrent(handle2520, 3, cboDet2CurrRng.ListIndex + 1, Det2Polarity) 'Set Det2 (Sense 3) Current measure range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

If SendKI(intKI2520, ":sour2:volt:lev " & Det1Bias) Then Exit Sub   'Configure Source 2 Voltage Range
If SendKI(intKI2520, ":sour3:volt:lev " & Det2Bias) Then Exit Sub   'Configure Source 3 Voltage Range
If SendKI(intKI2520, ":sens2:curr:rang " & Val(cboDet1CurrRng.Text)) Then Exit Sub 'Set Source 2 I measure range
If SendKI(intKI2520, ":sens3:curr:rang " & Val(cboDet2CurrRng.Text)) Then Exit Sub 'Set Source 3 I measure range
If optDet1Polarity(1).value Then            'Set det1 current measure polarity
    If SendKI(intKI2520, ":sens2:curr:pol pos") Then Exit Sub       'Set Det1 channel to Positive polarity
    Else
    If SendKI(intKI2520, ":sens2:curr:pol neg") Then Exit Sub       'Set Det1 channel to negative polarity
End If

If optDet2Polarity(1).value Then            'Set det2 current measure polarity
    If SendKI(intKI2520, ":sens3:curr:pol pos") Then Exit Sub       'Set Det1 channel to Positive polarity
    Else
    If SendKI(intKI2520, ":sens3:curr:pol neg") Then Exit Sub       'Set Det1 channel to negative polarity
End If

'Set V Measurement Range for Current Pulse
'nErr = Ke2520_ConfigureSenseVoltage(handle2520, cboVmeas.ListIndex + 1, KE2520_SOURCE_CURR_POL_POS) 'Configure Sense1 (laser diode) Voltage Range to 1=5V (2=10V), positive polarity
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sense1:volt:rang " & Val(cboVmeas.Text)) Then Exit Sub   'Configure Laser Diode V measure range (5 or 10 V)
        
''Configure Pulse
'If OutputShape = 1 Then                                 '=1 is pulse
'    If SendKI(intKI2520, ":sour:func puls") Then Exit Sub       'Set output for pulse
'    If SendKI(intKI2520, ":sour:puls:widt " & PulseWidth) Then Exit Sub 'Configure Pulse Width
'    If SendKI(intKI2520, ":sour:puls:del " & PulseDelay) Then Exit Sub 'Configure Pulse Delay (time between pulses)
'    'Disable transition control (for fastest rise time)
'    'If desired, choose transition control to slow rise time to 5 usec
'    'Below command not working on B00.3 firmware
''    If SendKI(intKI2520, ":sour:puls:trans:stat off") Then Exit Sub
'Else                                                    '=2 is DC
'    If SendKI(intKI2520, ":sour:func dc") Then Exit Sub         'Set output for DC
'End If
        
'Configure Current Output Mode (Sweep, not Fixed)
'nErr = Ke2520_ConfigureSourceCurrentMode(handle2520, KE2520_SOURCE_MODE_SWEEP, CurrentRange, KE2520_SOURCE_CURR_POL_POS, SweepStart)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

'Configure Current Source Range
If CurrentRange = 0 Then                                    '=0 is 500 mA range
If SendKI(intKI2520, ":sour:curr:rang 0.5") Then Exit Sub   'Set current output for 500 mA range
Else
If SendKI(intKI2520, ":sour:curr:rang 5") Then Exit Sub         'Set current output for 5 A range
End If

''Set up abort sweep on max current
'If SendKI(intKI2520, "sens3:swe:cab 0.0075") Then Exit Sub
'If SendKI(intKI2520, "sens3:swe:cab:stat ON") Then Exit Sub

'Configure Current Sweep
'If SendKI(intKI2520, ":sour:curr:mode sweep") Then Exit Sub
If SendKI(intKI2520, ":sour:swe:spac lin") Then Exit Sub    'Configure linear sweep
If SendKI(intKI2520, ":sour:curr:star " & SweepStart) Then Exit Sub 'Config sweep start current
If SendKI(intKI2520, ":sour:curr:stop " & SweepStop) Then Exit Sub  'Config sweep stop current
If SendKI(intKI2520, ":sour:curr:step " & SweepStep) Then Exit Sub  'Config sweep current step size
If SendKI(intKI2520, ":sour:curr:mode sweep") Then Exit Sub 'Choose sweep output
'If SendKI(intKI2520, ":sour:swe:spac lin") Then Exit Sub    'Configure linear sweep
'MsgBox ("Just finished sweep config")

''Configure Current Source Range
'If CurrentRange = 0 Then                                    '=0 is 500 mA range
'If SendKI(intKI2520, ":sour:curr:rang 0.5") Then Exit Sub   'Set current output for 500 mA range
'Else
'If SendKI(intKI2520, ":sour:curr:rang 5") Then Exit Sub         'Set current output for 5 A range
'End If

'Configure Current Source Polarity
If SendKI(intKI2520, ":sour:curr:pol pos") Then Exit Sub    'Set polarity=positive

'Configure Current Output Shape (DC or Pulse)
'nErr = Ke2520_ConfigureSourceShape(handle2520, OutputShape, PulseDelay, PulseWidth, SweepStart, 0)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'If SendKI(intKI2520, ":sour:curr
'Add code for pulse or dc???

'Configure Pulse
If OutputShape = 1 Then                                 '=1 is pulse
    If SendKI(intKI2520, ":sour:func puls") Then Exit Sub       'Set output for pulse
    If SendKI(intKI2520, ":sour:puls:widt " & PulseWidth) Then Exit Sub 'Configure Pulse Width
    If SendKI(intKI2520, ":sour:puls:del " & PulseDelay) Then Exit Sub 'Configure Pulse Delay (time between pulses)
    'Disable transition control (for fastest rise time)
    'If desired, choose transition control to slow rise time to 5 usec
    'Below command not working on B00.3 firmware
'    If SendKI(intKI2520, ":sour:puls:trans:stat off") Then Exit Sub
Else                                                    '=2 is DC
    If SendKI(intKI2520, ":sour:func dc") Then Exit Sub         'Set output for DC
End If

''Configure Current Sweep
'If SendKI(intKI2520, ":sour:curr:mode sweep") Then Exit Sub
'If SendKI(intKI2520, ":sour:swe:spac lin") Then Exit Sub    'Configure linear sweep
'If SendKI(intKI2520, ":sour:curr:star " & SweepStart) Then Exit Sub 'Config sweep start current
'If SendKI(intKI2520, ":sour:curr:stop " & SweepStop) Then Exit Sub  'Config sweep stop current
'If SendKI(intKI2520, ":sour:curr:step " & SweepStep) Then Exit Sub  'Config sweep current step size

DoEvents
'Configure Current source range (500 mA or 5A)
'nErr = Ke2520_ConfigureSourceSweep(handle2520, SweepStart, SweepStop, SweepStep, intSteps, CurrentRange) 'Configure the Sweep Parameters
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

End Sub

Public Sub OutputOff()
'This procedure turns off the 2520 output and sets output flag to false

'If outputting infinite train of fixed pulses, then an Abort command must
'be sent to turn off the 2520 output
If optShape(0).value = True Then        'Send abort, necessary to break the trigger=infinite condition
    If SendKI(intKI2520, "abor") Then Exit Sub          'Send abort, necessary to break the trigger=infinite condition
'    nErr = Ke2520_Abort(handle2520)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
End If

If SendKI(intKI2520, "outp off") Then Exit Sub      'Turn off 2520 output
    
'nErr = Ke2520_EnableSourceOutput(handle2520, VI_FALSE)       'Set 2520 Output off
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
'nErr = Ke2520_close(handle2520)                         'Close session to 2520
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

bln2520Output = False                       'Set 2520 output flag to False

End Sub

'Public Function DisplayError(sesn As ViSession, nErr As ViStatus)
''Display error from 2520 VISA driver
'
'Dim errMsg As String * 256
'Dim err As ViStatus
'Dim code As ViInt32
'
'    If nErr = KE2520_DEVICE_ERROR Then
'        err = Ke2520_GetLastError(sesn, code, errMsg)
'        MsgBox "Error = " & Str(code) & "  " & errMsg, vbOKOnly
'    Else
'        err = Ke2520_error_message(sesn, nErr, errMsg)
'        If err <> 0 Then
'            MsgBox "Error= " & Hex(nErr), vbOKOnly
'        Else
'            MsgBox "Error= " & Hex(nErr) & "  " & errMsg, vbOKOnly
'        End If
'    End If
'
'End Function

Public Sub DoSweep()
'This procedure will run the sweep on the 2520, close the 2520 session (handle),
'retrieve the data and calculate threshold (based on derivative(s))
'See routine ChartData for graphing of the sweep

Dim sngTempArray(1 To 5000) As Single       'Temporary array to initially hold data from 2520
Dim intScaleLDCurr As Integer               'Graphing scale factor to make LD current look OK
Dim dblSum As Double                    'Sum of second derivative values, used for Mean calc
Dim dblMaxima As Double                 'Max value of second derivative
Dim dblMinima As Double
Dim dblMean As Double                   'Mean value for dL2/dI2 (second derivative)
Dim intMaxPoint As Integer
Dim intNumBytes As Integer              'Number of bytes read
Dim i As Integer
'Troubleshooting code below
Dim status As Long
Dim intStatus As Integer
Dim length As Integer
'Dim length As Long

'Set graphing (charting) scale factors for each data set, these are just guesses
'because 2nd derivative plot can vary wildly, so auto-scaled can squash other curves
'using the same y-axis.  These are not part of the ChartData routine because ChartData
'is also used for replotting the data if user changes scale factors
intScaleLDCurr = 1                                'Note:  LD current is not graphed, but is part of grapharray, here for completeness
frmSweepChart.txtScaleLDVolt.Text = 1             'Initialize text boxes on Sweep Chart
frmSweepChart.txtScaleDet1Curr.Text = 1
frmSweepChart.txtScaleDet2Curr.Text = 450
frmSweepChart.txtScale1stDeriv.Text = 4000
frmSweepChart.txtScale2ndDeriv.Text = 40000

'Clear out the array used for receiving data from 2520
For i = 1 To 5000
sngTempArray(i) = 0
Next i

'Clear the graph array before updating the chart so that default
'psuedo noise is cleared from the chart display.

For i = 1 To 1010
    dblArray(intLDCurr, i) = 0                      'Data array, which is saved to disk
    dblArray(intLDVolt, i) = 0
    dblArray(intDet1Curr, i) = 0
    dblArray(intDet2Curr, i) = 0
    dblArray(int2ndDeriv, i) = 0
    dblArray(int1stDeriv, i) = 0
    dblGraphArray(intLDCurr, i) = 0                 'Graphing array, with graph scaling factors applied
    dblGraphArray(intLDVolt, i) = 0
    dblGraphArray(intDet1Curr, i) = 0
    dblGraphArray(intDet2Curr, i) = 0
    dblGraphArray(int2ndDeriv, i) = 0
    dblGraphArray(int1stDeriv, i) = 0
Next i

DoEvents
'MsgBox "press OK to start timer and sweep"
StartTime = Timer                               'grab a time stamp before starting test

shpOutputStatus.FillColor = &HFF0000            'make Output indicator Blue &H3366FF
DoEvents                                        'Update form, so indicator is updated

'nErr = Ke2520_EnableSourceOutput(handle2520, VI_TRUE)         'Turn Output ON
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, "outp on") Then Exit Sub   'Turn output on
If SendKI(intKI2520, "read?") Then Exit Sub      'Trigger sweep

Do                  'Loop until sweep is done
    DoEvents        'Passes control from VB to operating system
Loop Until (SrqKI And 1)            'Instrument will issue an SRQ (service request) once sweep is complete
poll = PollKI(intKI2520)            'clear SRQ status byte (& clears SRQ annunciator on front panel)

'Retrieve data, linear array: LD Current, LD voltage, Det1current, Det2 current
'nErr = Ke2520_Read(handle2520, 23, intSteps, sngTempArray(1))        ' Perform a Read, returning current, Vpulse(2), Det1 current (4), Det2 Current (16)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
If RecSetupKI(intKI2520) Then Exit Sub          'Configure GPIB board to listen, 2520 to talk
Call RecBinaryKI(sngTempArray(1), 2 * (intSteps * 4) * 4 + 1, length)    'Retrieve data for 4 elements (4 bytes each) for each step, 1 byte for terminator
If RecUndoKI(intKI2520) Then Exit Sub           'Return GPIB board to talk
    
'nErr = Ke2520_EnableSourceOutput(handle2520, VI_FALSE)  'Turn Output OFF
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

'nErr = Ke2520_close(handle2520)                         'Close session to 2520
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
                       
If SendKI(intKI2520, "outp off") Then Exit Sub   'Turn output off

shpOutputStatus.FillColor = &HC0C0C0                    'Change Output ON/Off indicator back to grey
DoEvents                                                'Update form, so indicator is updated
                       
                       
'Arrange data from 1 x 4n array to 4 x n array and calculate derivatives

dblMaxima = 0                                           'clear Maxima

For i = 1 To intSteps                                   'loop once (4* is for 4 values returned per sweep step)
'Note, 2 arrays were used dblArray (actual data, not manipulated), dblGraphArray (see ChartData routine)
    dblArray(intLDCurr, i) = sngTempArray(i * 4 - 3)    'Copy LD current into first array in 2-dim dblArray
    dblArray(intLDVolt, i) = sngTempArray(i * 4 - 2)    'Copy LD voltage to data dblArray
    dblArray(intDet1Curr, i) = Abs(sngTempArray(i * 4 - 1)) 'pass det 1 (front facet) to dblArray()
    dblArray(intDet2Curr, i) = sngTempArray(i * 4)          'pass channel 2 (back facet) to dblArray()
    
    If i <> 1 Then                                          'if not the first point, calculate dL/dI
        dblArray(int1stDeriv, i) = (dblArray(intDet1Curr, i) - dblArray(intDet1Curr, i - 1))
    End If                                                  'and record value in dblArray()
    If i > 2 Then                                           'if beyond second point calculate d2L/dI2
        dblArray(int2ndDeriv, i) = (dblArray(int1stDeriv, i) - dblArray(int1stDeriv, i - 1))
        If dblArray(int2ndDeriv, i) > dblMaxima Then        'look for first maxima, corresponding to lasing threshold
            dblMaxima = dblArray(int2ndDeriv, i)            'record current at maxima
            intMaxPoint = i                                 'record location of maxima
        End If
    End If
Next i

frmSweepChart.txtThresoldCurrent = Int(1000 * dblArray(intLDCurr, intMaxPoint)) / 1000   'display the current threshold)/1000

DoEvents                                                     'update display
               

'Find the Mean, Stddev, Maxima, and Minima of the d2L/dI2:
'Below code copied from 24xx DC LIV by Paul Meyer, et al

dblSum = 0              'clear variables
dblMaxima = 0
dblMinima = 0

For i = (intMaxPoint + 3) To intSteps - 1               'loop thru values of d2L/dI2
                                                        'beyond threshold current
    If dblArray(int2ndDeriv, i) > dblMaxima Then        'Find Maxima
        dblMaxima = dblArray(int2ndDeriv, i)
        intMaxPoint = i
    End If
    
    If dblArray(int2ndDeriv, i) < dblMinima Then        'Find Minima
        dblMinima = dblArray(int2ndDeriv, i)
        intMinPoint = i
    End If
    
    dblSum = dblSum + dblArray(int2ndDeriv, i)          'sum all the points (used for mean)
Next i

If Abs(intSteps - intMaxPoint) = 0 Then
    dblMean = 999
Else
    dblMean = dblSum / (intSteps - intMaxPoint)                       'calculate mean from sum
End If

dblSum = 0
For i = (intMaxPoint + 3) To intSteps                    'loop thru values again!
    dblSum = dblSum + (dblArray(int2ndDeriv, i) - dblMean) ^ 2  'calculate sum of differences
Next i

If Abs(intSteps - intMaxPoint) = 0 Then
    dblStddev = 999
Else
    dblStddev = Sqr(dblSum / (intSteps - intMaxPoint))                'calculate Standard Deviation
End If

frmSweepChart.txtKinkMaxima.Text = Int(1000 * dblArray(int2ndDeriv, intMaxPoint)) / 1000    'display maxima

If intMinPoint <> 0 Then
    frmSweepChart.txtKinkMinima.Text = Int(1000 * dblArray(int2ndDeriv, intMinPoint)) / 1000    'display minima
Else
    frmSweepChart.txtKinkMinima.Text = ""
End If

frmSweepChart.txtKinkStddev.Text = Int(1000 * dblStddev) / 1000                              'display Stddev


End Sub

Public Sub ConfigPulse2520()
'Configure 2520 to perform a single pulse
'then the data will be retrieved
'Use Pulse parameters from the cboPulseWidth and cboPulseDelay
'Use FixedCurrent, derived from txtDCCurrent

'Initial version of 2520 driver cannot query, so need to calculate
'the number of points in the buffer

PulsePoints = (PulseWidth * 10000000#) + 5      'Number of pulse points = (Pulse Width  10e6 +5)

'Initialise Ke2520, using VISA dll driver, and get session handle for 2520

'nErr = Ke2520_init("GPIB0::" & intKI2520 & "::INSTR", VI_ON, handle2520)   'GPIB: Reset 2520 and get handle
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, "*rst") Then Exit Sub
If SendKI(intKI2520, ":format:data sre;bord swap") Then Exit Sub    'send data from instrument in binary format

'Detector Channel measurement params
'nErr = Ke2520_ConfigureSourceVoltageLevel(handle2520, 2, Det1Bias)  'Configure Source 2 Voltage Range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSourceVoltageLevel(handle2520, 3, Det2Bias)  'Configure Source 3 Voltage Range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSenseCurrent(handle2520, 2, cboDet1CurrRng.ListIndex + 1, Det1Polarity) 'Set Det1 (Sense 2) Current measure range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSenseCurrent(handle2520, 3, cboDet2CurrRng.ListIndex + 1, Det2Polarity) 'Set Det2 (Sense 3) Current measure range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sour2:volt:lev " & Det1Bias) Then Exit Sub   'Configure Source 2 Voltage Range
If SendKI(intKI2520, ":sour3:volt:lev " & Det2Bias) Then Exit Sub   'Configure Source 3 Voltage Range
If SendKI(intKI2520, ":sens2:curr:rang " & Val(cboDet1CurrRng.Text)) Then Exit Sub 'Set Source 2 I measure range
If SendKI(intKI2520, ":sens3:curr:rang " & Val(cboDet2CurrRng.Text)) Then Exit Sub 'Set Source 3 I measure range
        
'Set V Measurement Range for LD drive pulse
'nErr = Ke2520_ConfigureSenseVoltage(handle2520, cboVmeas.ListIndex + 1, KE2520_SOURCE_CURR_POL_POS) 'Configure Sense1 (laser diode) Voltage Range to 1=5V (2=10V), positive polarity
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sense1:volt:rang " & Val(cboVmeas.Text)) Then Exit Sub   'Configure Laser Diode V measure range (5 or 10 V)

'Configure Current Output Mode (Fixed, not Sweep) and current Pulse value
'nErr = Ke2520_ConfigureSourceCurrentMode(handle2520, KE2520_SOURCE_MODE_FIXED_DC, CurrentRange, KE2520_SOURCE_CURR_POL_POS, FixedCurrent)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sour:curr:mode fix") Then Exit Sub           'Configure for fixed (not sweep) output
        
'Configure Current Source Range
If CurrentRange = 0 Then                                    '=0 is 500 mA range
If SendKI(intKI2520, ":sour:curr:rang 0.5") Then Exit Sub   'Set current output for 500 mA range
Else
If SendKI(intKI2520, ":sour:curr:rang 5") Then Exit Sub         'Set current output for 5 A range
End If
        
'Configure Current Output Shape: Pulse (not DC), Delay, Width, Current value, low value(0)
'nErr = Ke2520_ConfigureSourceShape(handle2520, OutputShape, CDbl(PulseDelay), CDbl(PulseWidth), CDbl(FixedCurrent), 0)  'Convert to Double to meet driver reqs
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sour:func puls") Then Exit Sub       'Set output for pulse
If SendKI(intKI2520, ":sour:puls:widt " & PulseWidth) Then Exit Sub 'Configure Pulse Width
If SendKI(intKI2520, ":sour:puls:del " & PulseDelay) Then Exit Sub  'Configure Pulse Delay (time between pulses)
If SendKI(intKI2520, ":sour:curr " & FixedCurrent) Then Exit Sub    'Set fixed current value for single pulse
        
'Configure Trace buffer (which data items to return)
'nErr = Ke2520_ConfigureBuffer(handle2520, PulsePoints)         'Set number of pulse samples to be returned
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":trac:poin " & PulsePoints) Then Exit Sub  'Set number of samples to be returned for the trace:data? query
If SendKI(intKI2520, ":form:elem:trac volt1, curr2, curr3, time") Then Exit Sub   'Return LD voltage, Det1 current, Det2 current, time stamp

End Sub

Public Sub ChartPulse()
'This routine triggers a pulse on the 2520, retrieves the data, and plots it
'and closes the session to the 2520
'Dim NumPulsePoints As ViInt32
Dim NumPulsePoints As Integer
Dim sngDataArray(1 To 12500) As Single
Dim sngTimearray(1 To 3000) As Single

shpOutputStatus.FillColor = &HFF0000            'make Output indicator Blue
DoEvents                                        'Update form, so indicator color is updated

'nErr = Ke2520_EnableSourceOutput(handle2520, VI_TRUE)            'Turn output on
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
'nErr = Ke2520_Initiate(handle2520)                              'Trigger a pulse
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'
'nErr = Ke2520_EnableSourceOutput(handle2520, VI_FALSE)            'Turn output off
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

If SendKI(intKI2520, "outp on") Then Exit Sub   'Turn output on
If SendKI(intKI2520, "init") Then Exit Sub      'Trigger single pulse
If SendKI(intKI2520, "outp off") Then Exit Sub   'Turn output off

shpOutputStatus.FillColor = &HC0C0C0            'Change Output ON/Off indicator back to grey
DoEvents                                        'Update form, so indicator is updated

'nErr = Ke2520_ReadBuffer(handle2520, 15, NumPulsePoints, sngDataArray(1))  'Read the Trace (pulse) buffer
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, "trac:data?") Then Exit Sub 'Query pulse data
If RecSetupKI(intKI2520) Then Exit Sub          'Configure GPIB board to listen, 2520 to talk
Call RecBinaryKI(sngDataArray(1), (PulsePoints * 4) * 4 + 1, NumPulsePoints)  'Retrieve data for 4 elements for each point

'nErr = Ke2520_close(handle2520)                         'Close session to 2520
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If

If RecUndoKI(intKI2520) Then Exit Sub                   'Config GPIB board to talk, instrument to listen

'Arrange data from 1 x 4n array to 4 x n 2-d array and calculate derivatives
For i = 1 To PulsePoints                                 'loop once ("*4" in below lines is for 4 values per reading)
    sngPulseArray(intPulseVolt, i) = sngDataArray(i * 4 - 3)         'Copy LD voltage into first array in 2-dim pulse array
    sngPulseArray(intPulseDet1, i) = Abs(sngDataArray(i * 4 - 2))         'Copy Det1 Current to data pulse array, no Det1-Det2 difference taken
    sngPulseArray(intPulseDet2, i) = Abs(sngDataArray(i * 4 - 1))         'Copy Det2 Current to data pulse array
    sngPulseArray(intPulseTime, i) = sngDataArray(i * 4)             'copy time value index into pulse array
Next i

'Chart the Pulse data

'Hide the time from being charted
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseTime).Position.Excluded = True

'Turn on Auto-scaling for both Y axes, which may have been turned off
'from a previous pulse plot by using the MSChart2_PointSelected routine
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdY).ValueScale.Auto = True    'Turn on auto-scaling
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdY2).ValueScale.Auto = True    'Turn on auto-scaling

'Use secondary (right side) y axis for the detector currents
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet1).SecondaryAxis = True
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).SecondaryAxis = True

'chart data
frmPulseChart.MSChart2.ColumnCount = PulsePoints     'scale x axis of chart
frmPulseChart.MSChart2.ChartData = sngPulseArray     'chart data points
frmPulseChart.MSChart2.ColumnCount = PulsePoints     'correct for stray points

'Set chart properties
'Label series and axes
frmPulseChart.MSChart2.row = intPulseVolt               'address row
frmPulseChart.MSChart2.RowLabel = "LD Voltage"          'caption for row
frmPulseChart.MSChart2.row = intPulseDet1
frmPulseChart.MSChart2.RowLabel = "Det 1 Curr (right axis)"
frmPulseChart.MSChart2.row = intPulseDet2
frmPulseChart.MSChart2.RowLabel = "Det 2 Curr (right axis)"
'Couldn't get x-axis label or grid/tic marks to really work, so just use a label
frmPulseChart.txtPulseXaxis.Text = "100 ns between points, Total points= " & PulsePoints
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdX).CategoryScale.Auto = False
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdX).CategoryScale.DivisionsPerTick = PulsePoints / 5
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdX, 1).AxisTitle.Visible = True
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdX).AxisTitle = "Time (in arb units)"
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdX, 1).AxisScale.Type = VtChScaleTypeLinear
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdY, 1).AxisTitle = "LD Voltage (V)"
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdY, 1).AxisTitle.VtFont.Size = 12
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdY2, 1).AxisTitle = "Detector Current (A)"
frmPulseChart.MSChart2.Plot.Axis(VtChAxisIdY2, 1).AxisTitle.VtFont.Size = 12

'Change background of chart to white (default= formbackground (=grey))
frmPulseChart.MSChart2.Backdrop.Fill.Style = VtFillStyleBrush
frmPulseChart.MSChart2.Backdrop.Fill.Brush.Style = VtBrushStyleSolid
frmPulseChart.MSChart2.Backdrop.Fill.Brush.FillColor.Set 255, 255, 255

'Customize the Pulse voltage series
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseVolt).SeriesMarker.Auto = False
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseVolt).DataPoints.Item(-1).Marker.Style = VtMarkerStyleFilledSquare
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseVolt).DataPoints.Item(-1).Marker.Size = 120
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseVolt).SeriesMarker.Show = True

'Customize the Pulse Detector 1 current series
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet1).SeriesMarker.Auto = False
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet1).DataPoints.Item(-1).Marker.Style = VtMarkerStyleFilledCircle
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet1).DataPoints.Item(-1).Marker.Size = 120
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet1).SeriesMarker.Show = True

'Customize the Pulse Detector 2 current series
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).SeriesMarker.Auto = False
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).DataPoints.Item(-1).Marker.Style = VtMarkerStyleFilledUpTriangle
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).DataPoints.Item(-1).Marker.Size = 120
frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).SeriesMarker.Show = True

'For non-Expert mode, hide the Detector 2 series, not necessary
'for resistor DUT because of the det1-det2 configuration
'NOTE:  Det1-det2 operation is not implemented for the single Pulse data


If frmMain.optDUTtype(0).value Or frmMain.optDUTtype(1).value Then
    frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).Position.Excluded = True
    frmPulseChart.MSChart2.row = intPulseDet1
    frmPulseChart.MSChart2.RowLabel = "Detector (right axis)"
    Else                                'If the DUT type is Expert then activate Det 2 series
    frmPulseChart.MSChart2.Plot.SeriesCollection(intPulseDet2).Position.Excluded = False
    frmPulseChart.MSChart2.row = intPulseDet1
    frmPulseChart.MSChart2.RowLabel = "Det 1 (right axis)"
End If

frmPulseChart.Show                      'Display Pulse form

End Sub

Public Sub ConfigFixed2520()
'This procedure programs the 2520 with the chosen Fixed Output (pulse or DC) parameters
'NOTE:  For Fixed Pulse or DC, this routine uses Trigger Count=Infinite, in which the 2520 does
'NOT collect data.  In the trigger count = infinite, there is an additional (2-3 ms) delay due
'to "housekeeping" in the 2520, so the time between pulses = PD + 2-3 ms.  To get around this
'housekeeping delay, use a fixed current sweep to provide a train of fixed current pulses (see
'#1 below for further info).
'
'There are two ways to collect data while having a fixed current pulse:
' 1)    For fixed width pulse, configure a sweep with stepcurrent = 0 A,
'       then use number of point (in Ke2520_ConfigureSourceSweep) to set
'       up to 1000 "steps" and collect the desired data for each pulse.
'2)     Use the Custom Sweep, by using the List Sweep set of functions,
'       such as Ke2520_ConfigureSourceListCurrent (see online 2520 driver
'       help and User Manual pgs 14-40).  There is a 1000 point maximum for
'       the custom sweep, but the info must be sent in 100 point chunks.
'       The 100 point limit is a GPIB limitation, so the data could be
'       sent with 1x100 point send and then 9 100 point appends.  This is
'       done by incrementing the numberofpoints passed to the
'       ConfigureSourceListxxxx function by the additional values desire
'       (for instance, the second 100 points would require numberofpoints=200)
'To take data in the Fixed DC mode:
'       Use the Ke2520_Fetch, or Ke2520_Read to retrieve readings.  This should be
'       done periodically (using a delay), based on the desired readings/time


'Initialise Ke2520, using VISA dll driver, and get session handle for 2520

'nErr = Ke2520_init("GPIB0::" & intKI2520 & "::INSTR", VI_ON, handle2520)   'GPIB: Reset 2520 and get handle
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, "*rst") Then Exit Sub
        
'CONFIGURE 2520
                
'Detector Channel measurement params
'nErr = Ke2520_ConfigureSourceVoltageLevel(handle2520, 2, Det1Bias)  'Configure Source 2 Voltage Range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSourceVoltageLevel(handle2520, 3, Det2Bias)  'Configure Source 3 Voltage Range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSenseCurrent(handle2520, 2, cboDet1CurrRng.ListIndex + 1, Det1Polarity) 'Set Det1 (Sense 2) Current measure range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
'nErr = Ke2520_ConfigureSenseCurrent(handle2520, 3, cboDet2CurrRng.ListIndex + 1, Det2Polarity) 'Set Det2 (Sense 3) Current measure range
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sour2:volt:lev " & Det1Bias) Then Exit Sub   'Configure Source 2 Voltage Range
If SendKI(intKI2520, ":sour3:volt:lev " & Det2Bias) Then Exit Sub   'Configure Source 3 Voltage Range
If SendKI(intKI2520, ":sens2:curr:rang " & Val(cboDet1CurrRng.Text)) Then Exit Sub 'Set Source 2 I measure range
If SendKI(intKI2520, ":sens3:curr:rang " & Val(cboDet2CurrRng.Text)) Then Exit Sub 'Set Source 3 I measure range
       
        
'Set trigger=infinite for train of Fixed Pulses
If optShape(0).value = True Then        'If Fixed Pulse, then set trigger to infinite
'    nErr = Ke2520_ConfigureTriggerLayer(handle2520, 0, KE2520_TRIG_ON_IMMEDIATE, KE2520_TLINK_LINE_1, KE2520_TLINK_LINE_2, KE2520_TRIG_OUTP_NONE)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
    If SendKI(intKI2520, ":trig:coun inf") Then Exit Sub      'Set trigger to infinite (run continuously)
End If

'Set V Measurement Range for Current Pulse
'nErr = Ke2520_ConfigureSenseVoltage(handle2520, cboVmeas.ListIndex + 1, KE2520_SOURCE_CURR_POL_POS) 'Configure Sense1 (laser diode) Voltage Range to 1=5V (2=10V), positive polarity
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If CurrentRange = 0 Then                                    '=0 is 500 mA range
    If SendKI(intKI2520, ":sour:curr:rang 0.5") Then Exit Sub   'Set current output for 500 mA range
    Else
    If SendKI(intKI2520, ":sour:curr:rang 5") Then Exit Sub         'Set current output for 5 A range
End If
        
        
'Configure Current Output Mode (Fixed, not Sweep)
'nErr = Ke2520_ConfigureSourceCurrentMode(handle2520, KE2520_SOURCE_MODE_FIXED_DC, CurrentRange, KE2520_SOURCE_CURR_POL_POS, FixedCurrent)
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If SendKI(intKI2520, ":sour:curr:mode fix") Then Exit Sub           'Configure for fixed (not sweep) output
If SendKI(intKI2520, ":sour:curr " & FixedCurrent) Then Exit Sub    'Set current value
        
'Configure Current Output Shape (DC or Pulse)
'nErr = Ke2520_ConfigureSourceShape(handle2520, OutputShape, CDbl(PulseDelay), CDbl(PulseWidth), CDbl(FixedCurrent), 0)  'Convert to Double to meet driver reqs
'    If nErr <> 0 Then
'        DisplayError handle2520, nErr
'    End If
If OutputShape = 1 Then                                 '=1 is pulse
    If SendKI(intKI2520, ":sour:func puls") Then Exit Sub       'Set output for pulse
    If SendKI(intKI2520, ":sour:puls:widt " & PulseWidth) Then Exit Sub 'Configure Pulse Width
    If SendKI(intKI2520, ":sour:puls:del " & PulseDelay) Then Exit Sub 'Configure Pulse Delay (time between pulses)
    'Disable transition control (for fastest rise time)
    'If desired, choose transition control to slow rise time to 5 usec
    'Below command not working on B00.3 firmware
'    If SendKI(intKI2520, ":sour:puls:trans:stat off") Then Exit Sub
Else                                                    '=2 is DC
    If SendKI(intKI2520, ":sour:func dc") Then Exit Sub         'Set output for DC
End If


End Sub

Public Sub CheckInterlock()
'This procedure checks the status of the 2520 output interlock
'NOTE:  Initial version of 2520 VISA driver does not support a
'query of the interlock, therefore this procedure isn't useful.
'(The SCPI command is ":OUTP1:INT:TRIP?")
'But the initial 2520 driver does trap and report the error
'("ERROR = 802 OUTPUT blocked by interlock"), but
'it then times out, but not gracefully.

'Add code here to query interlock status, then
'If (at least one of the) interlock is tripped (crkt(s) open), then
'output Msgbox with "check key and connector" and then disable
'the cmdOutputOnOff button
'If both interlocks aren't tripped, then enable cmdOutputOnOff button




End Sub

Function FileExists(strPath As String) As Boolean
'Checks for the existence of a file through kernel API.
'Description: Returns True if file exists, False otherwise
'* Author     : Francis Lomax and Paul Hickey,              *
'*            : Computer Law Systems, Inc.                  *

  Dim structFileInfo As OFSTRUCT

  On Error Resume Next

  If OpenFile(strPath, structFileInfo, OF_EXIST) <> -1 Then
    FileExists = True
  ElseIf structFileInfo.nErrCode = 32 Then
    ' File Lock Violation
    FileExists = True
  Else
    FileExists = False
  End If

  If Err.Number <> 0 Then FileExists = False

End Function

Public Sub GetSettings()
'Checks for existance of file=2520Demo.txt exists in same directory
'as the 2520 demo program.  If file exists, then loads values from file
'If no file, then display frmGPIBSettings
'Initial file contents only stores GPIB card choice
Dim blnSetFile As Boolean                      'Stores state of settings file (exist/doesn't exist)

'If it doesn't, automatically raise frmGPIBSettings to make user
'choose a GPIB card.
blnSetFile = FileExists(strSetFile)
'Troubleshooting code below
'MsgBox "Set file exists= " & blnSetFile & " FileExists= " & FileExists(strSetFile)

If blnSetFile Then 'readfile
    ReadSetting (strSetFile)
    Else: frmGPIBSettings.Show vbModal
End If

frmGPIBSettings.txt2520GPIB = intKI2520         'Copy value to displayed address
frmGPIBSettings.txt2510GPIB = intKI2510         'Copy value to displayed address

End Sub

